/*
 * Decompiled with CFR 0.152.
 */
package net.sf.maventaglib;

import com.sun.tlddoc.TLDDocGenerator;
import java.io.File;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.maventaglib.TaglibPlugin;

public class TaglibTaglibdocPlugin
extends TaglibPlugin {
    protected String title;
    protected String tldDocDir;

    public void setTitle(String docTitle) {
        this.title = docTitle;
    }

    public void setTldDocDir(String dir) {
        this.tldDocDir = dir;
    }

    public void execute() throws Exception {
        File srcDirFile = new File(this.srcDir);
        File tldOutDir = new File(this.tldDocDir);
        this.echo("Generating tlddoc doc from files in " + srcDirFile.getAbsolutePath());
        TLDDocGenerator generator = new TLDDocGenerator();
        generator.setOutputDirectory(tldOutDir);
        generator.setQuiet(true);
        generator.setWindowTitle(this.title);
        if (!srcDirFile.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + srcDirFile.getAbsolutePath());
        }
        File[] files = srcDirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            File current = files[i];
            if (!current.isDirectory() && current.getName().toLowerCase().endsWith(".tld")) {
                generator.addTLD(current);
            }
            ++i;
        }
        try {
            generator.generate();
        }
        catch (TransformerFactoryConfigurationError e) {
            this.echo("Unable to run tlddodc due to a TransformerFactoryConfigurationError: " + e.getMessage());
        }
    }
}

