/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tlddoc;

import com.sun.tlddoc.GeneratorException;
import com.sun.tlddoc.JARTLDFileTagLibrary;
import com.sun.tlddoc.TLDFileTagLibrary;
import com.sun.tlddoc.TagDirImplicitTagLibrary;
import com.sun.tlddoc.TagLibrary;
import com.sun.tlddoc.WARJARTLDFileTagLibrary;
import com.sun.tlddoc.WARTagDirImplicitTagLibrary;
import com.sun.tlddoc.tagfileparser.Attribute;
import com.sun.tlddoc.tagfileparser.Directive;
import com.sun.tlddoc.tagfileparser.ParseException;
import com.sun.tlddoc.tagfileparser.TagFile;
import com.sun.tlddoc.tagfileparser.TokenMgrError;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TLDDocGenerator {
    private ArrayList tagLibraries = new ArrayList();
    private File xsltDirectory = null;
    private File outputDirectory = new File("out");
    private String windowTitle = "Tag Library Documentation Generator - Generated Documentation";
    private String docTitle = "Tag Library Documentation Generator - Generated Documentation";
    private boolean quiet;
    private Document summaryTLD;
    private static final String RESOURCE_PATH = "/com/sun/tlddoc/resources";
    private int substitutePrefix = 1;
    static /* synthetic */ Class class$com$sun$tlddoc$TLDDocGenerator;

    public void addTagLibrary(TagLibrary tagLibrary) {
        this.tagLibraries.add(tagLibrary);
    }

    public void addTLD(File tld) {
        this.addTagLibrary((TagLibrary)new TLDFileTagLibrary(tld));
    }

    public void addWebApp(File path) {
        File webinf = new File(path, "WEB-INF");
        this.addWebAppTLDsIn(webinf);
        this.addWebAppJARsIn(new File(webinf, "lib"));
        this.addWebAppTagDirsIn(new File(webinf, "tags"));
    }

    private void addWebAppTLDsIn(File path) {
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addWebAppTLDsIn(files[i]);
                continue;
            }
            if (!files[i].getName().toLowerCase().endsWith(".tld")) continue;
            this.addTLD(files[i]);
        }
    }

    private void addWARTLDsIn(File war, String path) throws IOException {
        JarFile warFile = new JarFile(war);
        Enumeration<JarEntry> entries = warFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.startsWith(path) || !entryName.toLowerCase().endsWith(".tld")) continue;
            this.addTagLibrary((TagLibrary)new JARTLDFileTagLibrary(war, jarEntry.getName()));
        }
        warFile.close();
    }

    private void addWebAppJARsIn(File path) {
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addWebAppJARsIn(files[i]);
                continue;
            }
            if (!files[i].getName().toLowerCase().endsWith(".jar")) continue;
            this.addJAR(files[i]);
        }
    }

    private void addWARJARsIn(File war, String path) throws IOException {
        JarFile warFile = new JarFile(war);
        Enumeration<JarEntry> entries = warFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry warEntry = entries.nextElement();
            String entryName = warEntry.getName();
            if (!entryName.startsWith(path) || !entryName.toLowerCase().endsWith(".jar")) continue;
            try {
                JarEntry jarEntry;
                JarInputStream in = new JarInputStream(warFile.getInputStream(warEntry));
                while ((jarEntry = in.getNextJarEntry()) != null) {
                    if (!jarEntry.getName().toLowerCase().endsWith(".tld")) continue;
                    this.addTagLibrary((TagLibrary)new WARJARTLDFileTagLibrary(war, entryName, jarEntry.getName()));
                }
                in.close();
            }
            catch (IOException e) {
                this.println("WARNING: Could not access one or more entries in " + war.getAbsolutePath() + " entry " + entryName + ".  Skipping JAR.  Reason: " + e.getMessage());
            }
        }
        warFile.close();
    }

    private void addWebAppTagDirsIn(File path) {
        if (path.exists() && path.isDirectory()) {
            this.addTagDir(path);
            File[] files = path.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory()) continue;
                    this.addWebAppTagDirsIn(files[i]);
                }
            }
        }
    }

    private void addWARTagDirsIn(File war, String path) throws IOException {
        JarFile warFile = new JarFile(war);
        Enumeration<JarEntry> entries = warFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(path) || !entry.isDirectory()) continue;
            this.addTagLibrary((TagLibrary)new WARTagDirImplicitTagLibrary(war, entry.getName()));
        }
        warFile.close();
    }

    public void addJAR(File jar) {
        try {
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().toLowerCase().endsWith(".tld")) continue;
                this.addTagLibrary((TagLibrary)new JARTLDFileTagLibrary(jar, jarEntry.getName()));
            }
            jarFile.close();
        }
        catch (IOException e) {
            this.println("WARNING: Could not access one or more entries in " + jar.getAbsolutePath() + ".  Skipping JAR.  Reason: " + e.getMessage());
        }
    }

    public void addWAR(File path) {
        try {
            this.addWARTLDsIn(path, "WEB-INF/");
            this.addWARJARsIn(path, "WEB-INF/lib/");
            this.addWARTagDirsIn(path, "WEB-INF/tags/");
        }
        catch (IOException e) {
            this.println("WARNING: Could not access one or more entries in " + path.getAbsolutePath() + ".  Skipping WAR.  Reason: " + e.getMessage());
        }
    }

    public void addTagDir(File tagdir) {
        this.addTagLibrary((TagLibrary)new TagDirImplicitTagLibrary(tagdir));
    }

    public void setXSLTDirectory(File dir) {
        this.xsltDirectory = dir;
    }

    public void setOutputDirectory(File dir) {
        this.outputDirectory = dir;
    }

    public void setWindowTitle(String title) {
        this.windowTitle = title;
    }

    public void setDocTitle(String title) {
        this.docTitle = title;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void generate() throws GeneratorException, TransformerException {
        try {
            this.outputDirectory.mkdirs();
            this.copyStaticFiles();
            this.createTLDSummaryDoc();
            this.generateOverview();
            this.generateTLDDetail();
            this.outputSuccessMessage();
        }
        catch (IOException e) {
            throw new GeneratorException((Throwable)e);
        }
        catch (SAXException e) {
            throw new GeneratorException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new GeneratorException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new GeneratorException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new GeneratorException((Throwable)e);
        }
    }

    private void copyStaticFiles() throws IOException {
        this.copyResourceToFile(new File(this.outputDirectory, "stylesheet.css"), "/com/sun/tlddoc/resources/stylesheet.css");
    }

    private void createTLDSummaryDoc() throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, GeneratorException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new CharArrayReader(new char[0]));
            }
        });
        this.summaryTLD = documentBuilder.newDocument();
        Element rootElement = this.summaryTLD.createElementNS("http://java.sun.com/xml/ns/j2ee", "tlds");
        this.summaryTLD.appendChild(rootElement);
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://java.sun.com/xml/ns/j2ee");
        Element configElement = this.summaryTLD.createElementNS("http://java.sun.com/xml/ns/j2ee", "config");
        rootElement.appendChild(configElement);
        Element windowTitle = this.summaryTLD.createElementNS("http://java.sun.com/xml/ns/j2ee", "window-title");
        windowTitle.appendChild(this.summaryTLD.createTextNode(this.windowTitle));
        configElement.appendChild(windowTitle);
        Element docTitle = this.summaryTLD.createElementNS("http://java.sun.com/xml/ns/j2ee", "doc-title");
        docTitle.appendChild(this.summaryTLD.createTextNode(this.docTitle));
        configElement.appendChild(docTitle);
        Iterator iter = this.tagLibraries.iterator();
        this.println("Loading and translating " + this.tagLibraries.size() + " Tag Librar" + (this.tagLibraries.size() == 1 ? "y" : "ies") + "...");
        while (iter.hasNext()) {
            TagLibrary tagLibrary = (TagLibrary)iter.next();
            Document doc = tagLibrary.getTLDDocument(documentBuilder);
            int numTags = (doc = this.upgradeTLD(doc)).getDocumentElement().getElementsByTagNameNS("*", "tag").getLength() + doc.getDocumentElement().getElementsByTagNameNS("*", "tag-file").getLength() + doc.getDocumentElement().getElementsByTagNameNS("*", "validator").getLength() + doc.getDocumentElement().getElementsByTagNameNS("*", "function").getLength();
            if (numTags <= 0) continue;
            this.populateTLD(tagLibrary, doc);
            Element taglibNode = (Element)this.summaryTLD.importNode(doc.getDocumentElement(), true);
            if (!taglibNode.getNamespaceURI().equals("http://java.sun.com/xml/ns/j2ee")) {
                throw new GeneratorException("Error: " + tagLibrary.getPathDescription() + " does not have xmlns=\"" + "http://java.sun.com/xml/ns/j2ee" + "\"");
            }
            if (!taglibNode.getLocalName().equals("taglib")) {
                throw new GeneratorException("Error: " + tagLibrary.getPathDescription() + " does not have <taglib> as root.");
            }
            rootElement.appendChild(taglibNode);
        }
    }

    private Transformer getTransformer(StreamSource source) throws TransformerConfigurationException {
        Transformer transformer = null;
        try {
            transformer = source == null ? TransformerFactory.newInstance().newTransformer() : TransformerFactory.newInstance().newTransformer(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (transformer == null) {
            transformer = source == null ? new TransformerFactoryImpl().newTransformer() : new TransformerFactoryImpl().newTransformer((Source)source);
        }
        return transformer;
    }

    private Document upgradeTLD(Document doc) throws TransformerConfigurationException, ParserConfigurationException, TransformerException {
        Element root = doc.getDocumentElement();
        if (root.getElementsByTagName("jspversion").getLength() > 0) {
            doc = this.convertTLD(doc, "/com/sun/tlddoc/resources/tld1_1-tld1_2.xsl");
            root = doc.getDocumentElement();
        }
        if (root.getElementsByTagName("jsp-version").getLength() > 0) {
            doc = this.convertTLD(doc, "/com/sun/tlddoc/resources/tld1_2-tld2_0.xsl");
            root = doc.getDocumentElement();
        }
        doc = this.convertTLD(doc, "/com/sun/tlddoc/resources/tld2_0-tld2_0.xsl");
        return doc;
    }

    private Document convertTLD(Document doc, String stylesheet) throws TransformerConfigurationException, ParserConfigurationException, TransformerException {
        InputStream xsl = this.getResourceAsStream(stylesheet);
        Transformer transformer = this.getTransformer(new StreamSource(xsl));
        Document result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        transformer.transform(new DOMSource(doc), new DOMResult(result));
        return result;
    }

    private void populateTLD(TagLibrary tagLibrary, Document doc) {
        Element root = doc.getDocumentElement();
        this.checkOrAddShortName(tagLibrary, doc, root);
        this.checkOrAddAttributeType(tagLibrary, doc, root);
        this.populateTagFileDetails(tagLibrary, doc, root);
    }

    private void populateTagFileDetails(TagLibrary tagLibrary, Document doc, Element root) {
        NodeList tagFileNodes = root.getElementsByTagNameNS("*", "tag-file");
        for (int i = 0; i < tagFileNodes.getLength(); ++i) {
            Element tagFileNode = (Element)tagFileNodes.item(i);
            String path = this.findElementValue(tagFileNode, "path");
            if (path == null) {
                this.println("WARNING: " + tagLibrary.getPathDescription() + " contains a tag-file element with no path.  Skipping.");
                continue;
            }
            try {
                InputStream tagFileIn = tagLibrary.getResource(path);
                if (tagFileIn == null) {
                    this.println("WARNING: Could not find tag file '" + path + "' for tag library " + tagLibrary.getPathDescription() + ".  Data will be incomplete for this tag.");
                    continue;
                }
                this.println("Parsing tag file: " + path);
                TagFile tagFile = TagFile.parse((InputStream)tagFileIn);
                ArrayList directives = tagFile.getDirectives();
                for (int j = 0; j < directives.size(); ++j) {
                    Directive directive = (Directive)directives.get(j);
                    String name = directive.getDirectiveName();
                    if (name.equals("tag")) {
                        this.populateTagFileDetailsTagDirective(tagFileNode, doc, directive);
                        continue;
                    }
                    if (name.equals("attribute")) {
                        this.populateTagFileDetailsAttributeDirective(tagFileNode, doc, directive);
                        continue;
                    }
                    if (!name.equals("variable")) continue;
                    this.populateTagFileDetailsVariableDirective(tagFileNode, doc, directive);
                }
                this.populateTagFileDetailsTagDefaults(tagFileNode, doc, path);
                continue;
            }
            catch (IOException e) {
                this.println("WARNING: Could not read tag file '" + path + "' for tag library " + tagLibrary.getPathDescription() + ".  Data will be incomplete for this tag." + "  Reason: " + e.getMessage());
                continue;
            }
            catch (ParseException e) {
                this.println("WARNING: Could not parse tag file '" + path + "' for tag library " + tagLibrary.getPathDescription() + ".  Data will be incomplete for this tag." + "  Reason: " + e.getMessage());
                continue;
            }
            catch (TokenMgrError e) {
                this.println("WARNING: Could not parse tag file '" + path + "' for tag library " + tagLibrary.getPathDescription() + ".  Data will be incomplete for this tag." + "  Reason: " + e.getMessage());
            }
        }
    }

    private void populateTagFileDetailsTagDirective(Element tagFileNode, Document doc, Directive directive) {
        Iterator attributes = directive.getAttributes();
        while (attributes.hasNext()) {
            Element icon;
            Element element;
            Attribute attribute = (Attribute)attributes.next();
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.equals("display-name") || name.equals("body-content") || name.equals("dynamic-attributes") || name.equals("description") || name.equals("example")) {
                element = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", name);
                element.appendChild(doc.createTextNode(value));
                tagFileNode.appendChild(element);
                continue;
            }
            if (!name.equals("small-icon") && !name.equals("large-icon")) continue;
            NodeList icons = tagFileNode.getElementsByTagNameNS("*", "icon");
            if (icons.getLength() == 0) {
                icon = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", "icon");
                tagFileNode.appendChild(icon);
            } else {
                icon = (Element)icons.item(0);
            }
            element = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", name);
            element.appendChild(doc.createTextNode(value));
            icon.appendChild(element);
        }
    }

    private void populateTagFileDetailsTagDefaults(Element tagFileNode, Document doc, String path) {
        String displayName = path.substring(path.lastIndexOf(47) + 1);
        displayName = displayName.substring(0, displayName.lastIndexOf(46));
        this.populateDefault(doc, tagFileNode, "display-name", displayName);
        this.populateDefault(doc, tagFileNode, "body-content", "scriptless");
        this.populateDefault(doc, tagFileNode, "dynamic-attributes", "false");
    }

    private void populateDefault(Document doc, Element parent, String tagName, String defaultValue) {
        if (this.findElementValue(parent, tagName) == null) {
            Element element = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", tagName);
            element.appendChild(doc.createTextNode(defaultValue));
            parent.appendChild(element);
        }
    }

    private void populateTagFileDetailsAttributeDirective(Element tagFileNode, Document doc, Directive directive) {
        Iterator attributes = directive.getAttributes();
        Element attributeNode = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", "attribute");
        tagFileNode.appendChild(attributeNode);
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            String name = attribute.getName();
            String value = attribute.getValue();
            if (!name.equals("name") && !name.equals("required") && !name.equals("fragment") && !name.equals("rtexprvalue") && !name.equals("type") && !name.equals("description")) continue;
            Element element = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", name);
            element.appendChild(doc.createTextNode(value));
            attributeNode.appendChild(element);
        }
        this.populateDefault(doc, attributeNode, "required", "false");
        this.populateDefault(doc, attributeNode, "fragment", "false");
        this.populateDefault(doc, attributeNode, "rtexprvalue", "false");
        String fragmentValue = this.findElementValue(attributeNode, "fragment");
        boolean fragment = fragmentValue != null && !fragmentValue.equalsIgnoreCase("false");
        this.populateDefault(doc, attributeNode, "type", fragment ? "javax.servlet.jsp.tagext.JspFragment" : "java.lang.String");
    }

    private void populateTagFileDetailsVariableDirective(Element tagFileNode, Document doc, Directive directive) {
        Iterator attributes = directive.getAttributes();
        Element variableNode = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", "variable");
        tagFileNode.appendChild(variableNode);
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            String name = attribute.getName();
            String value = attribute.getValue();
            if (!name.equals("name-given") && !name.equals("name-from-attribute") && !name.equals("variable-class") && !name.equals("declare") && !name.equals("scope") && !name.equals("description")) continue;
            Element element = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", name);
            element.appendChild(doc.createTextNode(value));
            variableNode.appendChild(element);
        }
        this.populateDefault(doc, variableNode, "variable-class", "java.lang.String");
        this.populateDefault(doc, variableNode, "declare", "true");
        this.populateDefault(doc, variableNode, "scope", "NESTED");
    }

    private void checkOrAddShortName(TagLibrary tagLibrary, Document doc, Element root) {
        if (root.getElementsByTagNameNS("*", "short-name").getLength() == 0) {
            String prefix = "prefix" + this.substitutePrefix;
            ++this.substitutePrefix;
            Element shortName = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", "short-name");
            shortName.appendChild(doc.createTextNode(prefix));
            root.appendChild(shortName);
            this.println("WARNING: " + tagLibrary.getPathDescription() + " is missing a short-name element.  Using " + prefix + ".");
        }
    }

    private void checkOrAddAttributeType(TagLibrary tagLibrary, Document doc, Element root) {
        NodeList tagNodes = root.getElementsByTagNameNS("*", "tag");
        for (int i = 0; i < tagNodes.getLength(); ++i) {
            Element tagElement = (Element)tagNodes.item(i);
            NodeList attributeNodes = tagElement.getElementsByTagNameNS("*", "attribute");
            for (int j = 0; j < attributeNodes.getLength(); ++j) {
                Element attributeElement = (Element)attributeNodes.item(j);
                if (attributeElement.getElementsByTagNameNS("*", "type").getLength() != 0) continue;
                String defaultType = "java.lang.String";
                String fragment = this.findElementValue(attributeElement, "fragment");
                if (fragment != null && (fragment.trim().equalsIgnoreCase("true") || fragment.trim().equalsIgnoreCase("yes"))) {
                    defaultType = "javax.servlet.jsp.tagext.JspFragment";
                }
                Element typeElement = doc.createElementNS("http://java.sun.com/xml/ns/j2ee", "type");
                typeElement.appendChild(doc.createTextNode(defaultType));
                attributeElement.appendChild(typeElement);
            }
        }
    }

    private void generateOverview() throws IOException, TransformerException {
        this.generatePage(new File(this.outputDirectory, "index.html"), "/com/sun/tlddoc/resources/index.html.xsl");
        this.generatePage(new File(this.outputDirectory, "help-doc.html"), "/com/sun/tlddoc/resources/help-doc.html.xsl");
        this.generatePage(new File(this.outputDirectory, "overview-frame.html"), "/com/sun/tlddoc/resources/overview-frame.html.xsl");
        this.generatePage(new File(this.outputDirectory, "alltags-frame.html"), "/com/sun/tlddoc/resources/alltags-frame.html.xsl");
        this.generatePage(new File(this.outputDirectory, "alltags-noframe.html"), "/com/sun/tlddoc/resources/alltags-noframe.html.xsl");
        this.generatePage(new File(this.outputDirectory, "overview-summary.html"), "/com/sun/tlddoc/resources/overview-summary.html.xsl");
    }

    private void generateTLDDetail() throws IOException, GeneratorException, TransformerException {
        ArrayList<String> shortNames = new ArrayList<String>();
        Element root = this.summaryTLD.getDocumentElement();
        NodeList taglibs = root.getElementsByTagNameNS("*", "taglib");
        int size = taglibs.getLength();
        for (int i = 0; i < size; ++i) {
            Element taglib = (Element)taglibs.item(i);
            String shortName = this.findElementValue(taglib, "short-name");
            String displayName = this.findElementValue(taglib, "display-name");
            if (shortNames.contains(shortName)) {
                throw new GeneratorException("Two tag libraries exist with the same short-name '" + shortName + "'.  This is not yet supported.");
            }
            String name = displayName;
            if (name == null) {
                name = shortName;
            }
            this.println("Generating docs for " + name + "...");
            shortNames.add(shortName);
            File outDir = new File(this.outputDirectory, shortName);
            outDir.mkdir();
            this.generateTLDDetail(outDir, shortName);
            NodeList tags = taglib.getElementsByTagNameNS("*", "tag");
            int numTags = tags.getLength();
            for (int j = 0; j < numTags; ++j) {
                Element tag = (Element)tags.item(j);
                String tagName = this.findElementValue(tag, "name");
                this.generateTagDetail(outDir, shortName, tagName);
            }
            NodeList tagFiles = taglib.getElementsByTagNameNS("*", "tag-file");
            int numTagFiles = tagFiles.getLength();
            for (int j = 0; j < numTagFiles; ++j) {
                Element tagFile = (Element)tagFiles.item(j);
                String tagFileName = this.findElementValue(tagFile, "name");
                this.generateTagDetail(outDir, shortName, tagFileName);
            }
            NodeList functions = taglib.getElementsByTagNameNS("*", "function");
            int numFunctions = functions.getLength();
            for (int j = 0; j < numFunctions; ++j) {
                Element function = (Element)functions.item(j);
                String functionName = this.findElementValue(function, "name");
                this.generateFunctionDetail(outDir, shortName, functionName);
            }
        }
    }

    private void generateTLDDetail(File outDir, String shortName) throws IOException, TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tlddoc-shortName", shortName);
        this.generatePage(new File(outDir, "tld-frame.html"), "/com/sun/tlddoc/resources/tld-frame.html.xsl", parameters);
        this.generatePage(new File(outDir, "tld-summary.html"), "/com/sun/tlddoc/resources/tld-summary.html.xsl", parameters);
    }

    private void generateTagDetail(File outDir, String shortName, String tagName) throws IOException, TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tlddoc-shortName", shortName);
        parameters.put("tlddoc-tagName", tagName);
        this.generatePage(new File(outDir, tagName + ".html"), "/com/sun/tlddoc/resources/tag.html.xsl", parameters);
    }

    private void generateFunctionDetail(File outDir, String shortName, String functionName) throws IOException, TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tlddoc-shortName", shortName);
        parameters.put("tlddoc-functionName", functionName);
        this.generatePage(new File(outDir, functionName + ".fn.html"), "/com/sun/tlddoc/resources/function.html.xsl", parameters);
    }

    private String findElementValue(Element parent, String tagName) {
        Element child;
        Node body;
        String result = null;
        NodeList elements = parent.getElementsByTagNameNS("*", tagName);
        if (elements.getLength() >= 1 && (body = (child = (Element)elements.item(0)).getFirstChild()).getNodeType() == 3) {
            result = body.getNodeValue();
        }
        return result;
    }

    private void generatePage(File outFile, String inputXSL) throws IOException, TransformerException {
        this.generatePage(outFile, inputXSL, null);
    }

    private void generatePage(File outFile, String inputXSL, Map parameters) throws IOException, TransformerException {
        InputStream xsl = this.getResourceAsStream(inputXSL);
        Transformer transformer = this.getTransformer(new StreamSource(xsl));
        if (parameters != null) {
            Iterator params = parameters.keySet().iterator();
            while (params.hasNext()) {
                String key = (String)params.next();
                Object value = parameters.get(key);
                transformer.setParameter(key, value);
            }
        }
        transformer.transform(new DOMSource(this.summaryTLD), new StreamResult(outFile));
    }

    private void copyResourceToFile(File outputFile, String resource) throws IOException {
        int len;
        InputStream in = this.getResourceAsStream(resource);
        FileOutputStream out = new FileOutputStream(outputFile);
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
    }

    private void println(String message) {
        if (!this.quiet) {
            System.out.println(message);
        }
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream result = null;
        if (this.xsltDirectory != null) {
            File resourceFile = new File(this.xsltDirectory, resource.substring(RESOURCE_PATH.length() + 1));
            try {
                result = new FileInputStream(resourceFile);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (result == null) {
            result = (class$com$sun$tlddoc$TLDDocGenerator == null ? (class$com$sun$tlddoc$TLDDocGenerator = TLDDocGenerator.class$("com.sun.tlddoc.TLDDocGenerator")) : class$com$sun$tlddoc$TLDDocGenerator).getResourceAsStream(resource);
        }
        return result;
    }

    private void outputSuccessMessage() {
        this.println("\nDocumentation generated.  If your tag library is intended for public use, \nplease add it to the repository at http://taglibrarydoc.dev.java.net/");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

