<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xhtml" encoding="UTF-8" />
  <xsl:template match="/">
    <document>
      <properties>
        <title>Tag library validation report</title>
      </properties>
      <body>
        <section name="Tag library validation report">
          <p> Tag library validation report automatically generated by the <a 
            href="http://maven-taglib.sourceforge.net" target="_blank">Maven taglib plugin</a>. This report contains a 
            basic validation of tag handler classes for the following tag libraries:</p>
          <ul>
            <xsl:for-each select="/document/tld">
              <li>
                <xsl:value-of select="@name" />
              </li>
            </xsl:for-each>
          </ul>
        </section>
        <xsl:apply-templates select="/document/tld" />
      </body>
    </document>
  </xsl:template>
  <xsl:template match="tld">
    <section>
      <xsl:attribute name="name">
        <xsl:value-of select="@name" />
        <xsl:text>&#x20;</xsl:text>
        <xsl:value-of select="@file" />
      </xsl:attribute>
      <xsl:apply-templates select="tag" />
    </section>
  </xsl:template>
  <xsl:template match="tag">
    <subsection>
      <xsl:attribute name="name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
      <table>
        <thead>
          <tr>
            <th title="Does the tag class exist?">
              <span style="cursor:help; border-bottom: 1px dotted #000;">found</span>
            </th>
            <th title="Is the tag class loadable?">
              <span style="cursor:help; border-bottom: 1px dotted #000;">loadable</span>
            </th>
            <th title="Does the tag class correctly extend TagSupport or TagExtraInfo?" >
              <span style="cursor:help; border-bottom: 1px dotted #000;">extends</span>
            </th>
            <th>class</th>
          </tr>
        </thead>
        <tbody>
          <xsl:apply-templates select="tagclass|teiclass" />
        </tbody>
      </table>
      <xsl:apply-templates select="attributes" />
    </subsection>
  </xsl:template>
  <xsl:template match="tagclass|teiclass">
    <tr>
      <td style="width:20px">
        <xsl:call-template name="image">
          <xsl:with-param name="result" select="@found" />
        </xsl:call-template>
      </td>
      <td style="width:20px">
        <xsl:call-template name="image">
          <xsl:with-param name="result" select="@loadable" />
        </xsl:call-template>
      </td>
      <td style="width:20px">
        <xsl:call-template name="image">
          <xsl:with-param name="result" select="@extend" />
        </xsl:call-template>
      </td>
      <td>
        <xsl:value-of select="@name" />
      </td>
    </tr>
  </xsl:template>
  <xsl:template name="image">
    <xsl:param name="result" />
    <xsl:choose>
      <xsl:when test="$result = 'error'">
        <img src="images/icon_error_sml.gif" width="15" height="15" alt="Error" />
      </xsl:when>
      <xsl:when test="$result = 'warning'">
        <img src="images/icon_warning_sml.gif" width="15" height="15" alt="Warning" />
      </xsl:when>
      <xsl:when test="$result = 'info'">
        <img src="images/icon_info_sml.gif" width="15" height="15" alt="Info" />
      </xsl:when>
      <xsl:otherwise>
        <img src="images/icon_success_sml.gif" width="15" height="15" alt="Ok" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="attributes">
    <table>
      <thead>
        <tr>
          <th style="width:20px">
          </th>
          <th>attribute name</th>
          <th>tld declares</th>
          <th>tag declares</th>
        </tr>
      </thead>
      <tbody>
        <xsl:apply-templates select="attribute" />
      </tbody>
    </table>
  </xsl:template>
  <xsl:template match="attribute">
    <tr>
      <td style="width:20px">
        <xsl:attribute name="rowspan">
          <xsl:value-of select="count(error) + 1" />
        </xsl:attribute>
        <xsl:choose>
          <xsl:when test="not(count(error[@level = 'error']) = 0)">
            <xsl:call-template name="image">
              <xsl:with-param name="result">error</xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="not(count(error[@level = 'warning']) = 0)">
            <xsl:call-template name="image">
              <xsl:with-param name="result">warning</xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="not(count(error[@level = 'info']) = 0)">
            <xsl:call-template name="image">
              <xsl:with-param name="result">info</xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="image" />
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:value-of select="@tldname" />
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="starts-with(@tldtype,'java.lang.')">
            <xsl:value-of select="substring-after(@tldtype,'java.lang.')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="@tldtype" />
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="starts-with(@tagtype,'java.lang.')">
            <xsl:value-of select="substring-after(@tagtype,'java.lang.')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="@tagtype" />
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <xsl:apply-templates select="error" />
  </xsl:template>
  <xsl:template match="error">
    <tr>
      <td colspan="3">
        <xsl:value-of select="." />
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>