/**
 * Copyright 2004 Fabrizio Giustina.
 *
 * Licensed under the Artistic License; you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://maven-taglib.sourceforge.net/license.html
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
package net.sf.maventaglib;

import java.io.File;


/**
 * Converter between dfferent versions of tlds.
 * @author Fabrizio Giustina
 * @version $Id: TaglibConvertPlugin.java,v 1.5 2005/08/23 12:29:52 fgiust Exp $
 */
public class TaglibConvertPlugin extends TaglibPlugin
{

    /**
     * output version for the converted tld.
     */
    private String outputVersion;

    /**
     * input version for the converted tld.
     */
    private String inputVersion;

    /**
     * Sets the output version for the converted tld.
     * @param version output version for the converted tld
     */
    public void setOutputVersion(String version)
    {
        this.outputVersion = version;
    }

    /**
     * Sets the input version for the converted tld.
     * @param version input version for the converted tld
     */
    public void setInputVersion(String version)
    {
        this.inputVersion = version;
    }

    /**
     * @see net.sf.maventaglib.TaglibPlugin#execute()
     */
    public void execute() throws Exception
    {

        if (this.inputVersion == null)
        {
            throw new IllegalArgumentException("Input version not set.");
        }
        if (this.outputVersion == null)
        {
            throw new IllegalArgumentException("Output version not set.");
        }

        String stylesheet = null;

        if ("1.2".equals(this.inputVersion) && "1.1".equals(this.outputVersion))
        {
            stylesheet = "/tld1_2-tld1_1.xsl";
        }
        else if ("1.1".equals(this.inputVersion) && "1.2".equals(this.outputVersion))
        {
            stylesheet = "/tld1_1-tld1_2.xsl";
        }
        else if ("1.2".equals(this.inputVersion) && "2.0".equals(this.outputVersion))
        {
            stylesheet = "/tld1_2-tld2_0.xsl";
        }
        else
        {
            throw new IllegalArgumentException("Conversion from version "
                + this.inputVersion
                + " to "
                + this.outputVersion
                + " not supported");
        }

        File inputFile = new File(srcDir + "/" + tldSrc);
        File outputFile = new File(outputDir + "/" + tldOut);

        echo("Generating " + tldOut + " [" + this.outputVersion + "] from " + tldSrc + " [" + this.inputVersion + "]");
        applyXslt(inputFile, stylesheet, outputFile);
    }

}