/**
 * Copyright 2004 Fabrizio Giustina.
 *
 * Licensed under the Artistic License; you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://maven-taglib.sourceforge.net/license.html
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
package net.sf.maventaglib;

import java.io.File;

import javax.xml.transform.TransformerFactoryConfigurationError;

import com.sun.tlddoc.TLDDocGenerator;


/**
 * Plugins which generates taglibdoc documentation.
 * @author Fabrizio Giustina
 * @version $Id: TaglibTaglibdocPlugin.java,v 1.8 2005/08/23 12:29:52 fgiust Exp $
 */
public class TaglibTaglibdocPlugin extends TaglibPlugin
{

    /**
     * title for tlddoc generated documentation.
     */
    protected String title;

    /**
     * TldDoc output dir.
     */
    protected String tldDocDir;

    /**
     * Sets the title for tlddoc generated docs.
     * @param docTitle title for tlddoc generated documentation.
     */
    public void setTitle(String docTitle)
    {
        this.title = docTitle;
    }

    /**
     * Sets the TldDoc output dir.
     * @param dir output directory for tlddoc documentation
     */
    public void setTldDocDir(String dir)
    {
        this.tldDocDir = dir;
    }

    /**
     * @see net.sf.maventaglib.TaglibPlugin#execute()
     */
    public void execute() throws Exception
    {
        File srcDirFile = new File(this.srcDir);
        File tldOutDir = new File(this.tldDocDir);
        echo("Generating tlddoc doc from files in " + srcDirFile.getAbsolutePath());
        TLDDocGenerator generator = new TLDDocGenerator();
        generator.setOutputDirectory(tldOutDir);
        generator.setQuiet(true);
        generator.setWindowTitle(this.title);

        if (!srcDirFile.isDirectory())
        {
            throw new IllegalArgumentException("Not a directory: " + srcDirFile.getAbsolutePath());
        }

        File[] files = srcDirFile.listFiles();
        for (int i = 0; i < files.length; i++)
        {
            File current = files[i];
            if (!current.isDirectory() && current.getName().toLowerCase().endsWith(".tld"))
            {
                generator.addTLD(current);
            }
        }

        try
        {
            generator.generate();
        }
        catch (TransformerFactoryConfigurationError e)
        {
            this.echo("Unable to run tlddodc due to a TransformerFactoryConfigurationError: " + e.getMessage());
        }
    }

}