/**
 * Copyright 2004 Fabrizio Giustina.
 *
 * Licensed under the Artistic License; you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://maven-taglib.sourceforge.net/license.html
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
package net.sf.maventaglib;

import java.io.File;


/**
 * Generates a tag reference xdoc that can be integrated in a maven generated site.
 * @author Fabrizio Giustina
 * @version $Id: TaglibTagreferencePlugin.java,v 1.5 2005/08/23 12:29:52 fgiust Exp $
 */
public class TaglibTagreferencePlugin extends TaglibPlugin
{

    /**
     * Tag reference ouput file.
     */
    protected String tagreference;

    /**
     * Sets the output file name for the tag reference xdoc.
     * @param file output file name for the tag reference xdoc
     */
    public void setTagreference(String file)
    {
        this.tagreference = file;
    }

    /**
     * @see net.sf.maventaglib.TaglibPlugin#execute()
     */
    public void execute() throws Exception
    {
        File srcDirFile = new File(srcDir);
        if (!srcDirFile.isDirectory())
        {
            throw new IllegalArgumentException("Not a directory: " + srcDirFile.getAbsolutePath());
        }

        File[] files = srcDirFile.listFiles();
        for (int i = 0; i < files.length; i++)
        {
            File current = files[i];
            if (!current.isDirectory() && current.getName().toLowerCase().endsWith(".tld"))
            {
                String fileName = current.getName();
                String fullName = this.tagreference + "-" + fileName.substring(0, fileName.indexOf(".tld")) + ".xml";

                echo("Generating tag reference doc from " + fileName + ", saving as " + fullName);
                File output = new File(fullName);
                applyXslt(current, "/taglibdoc.xsl", output);
            }
        }

    }
}