/**
 * Copyright 2004 Fabrizio Giustina.
 *
 * Licensed under the Artistic License; you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://maven-taglib.sourceforge.net/license.html
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
package net.sf.maventaglib;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;

import net.sf.maventaglib.checker.Tld;
import net.sf.maventaglib.checker.TldChecker;
import net.sf.maventaglib.checker.TldParser;

import org.dom4j.io.DocumentSource;
import org.w3c.dom.Document;


/**
 * Generates a tag library validation report.
 * @author Fabrizio Giustina
 * @version $Id: TaglibValidatePlugin.java,v 1.5 2005/08/23 12:29:52 fgiust Exp $
 */
public class TaglibValidatePlugin extends TaglibPlugin
{

    /**
     * Taglib validation ouput file.
     */
    protected String report;

    /**
     * Sets the output file name for the taglib validation xdoc.
     * @param file output file name for the taglib validation xdoc
     */
    public void setReport(String file)
    {
        this.report = file;
    }

    /**
     * @see net.sf.maventaglib.TaglibPlugin#execute()
     */
    public void execute() throws Exception
    {
        File srcDirFile = new File(this.srcDir);
        File outFile = new File(this.report);
        echo("Validating tld files in " + srcDirFile.getAbsolutePath());
        if (!srcDirFile.isDirectory())
        {
            throw new IllegalArgumentException("Not a directory: " + srcDirFile.getAbsolutePath());
        }

        File[] files = srcDirFile.listFiles();
        DocumentBuilder builder = getDocumentBuilder();
        List tldList = new ArrayList();
        for (int i = 0; i < files.length; i++)
        {
            File current = files[i];
            if (!current.isDirectory() && current.getName().toLowerCase().endsWith(".tld"))
            {
                Document tldDoc = builder.parse(current);
                Tld tld = TldParser.parse(tldDoc, current.getName());
                tldList.add(tld);
            }
        }
        if (tldList.size() == 0)
        {
            echo("No tlds found in " + srcDirFile.getAbsolutePath() + "!");
            return;
        }

        TldChecker checker = new TldChecker();
        org.dom4j.Document checked = checker.check((Tld[]) tldList.toArray(new Tld[tldList.size()]));

        this.applyXslt(new DocumentSource(checked), "/taglibvalidate.xsl", outFile);
    }
}