/**
 * Copyright 2004 Fabrizio Giustina.
 *
 * Licensed under the Artistic License; you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://maven-taglib.sourceforge.net/license.html
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
package net.sf.maventaglib.checker;


import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;


/**
 * Contains information about a tag.
 * @author Fabrizio Giustina
 * @version $Revision $ ($Author $)
 */
public class Tag
{

    /**
     * tag name.
     */
    private String name;

    /**
     * tag class.
     */
    private String tagClass;

    /**
     * TEI (tag extra info) class.
     */
    private String teiClass;

    /**
     * list of attributes for this tag.
     */
    private TagAttribute[] attributes;

    /**
     * Returns the tag name.
     * @return tag name
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Sets the tag name.
     * @param tagName tag name
     */
    public void setName(String tagName)
    {
        this.name = tagName;
    }

    /**
     * @return Returns the attributes.
     */
    public TagAttribute[] getAttributes()
    {
        return this.attributes;
    }

    /**
     * @param tagAttributes The attributes to set.
     */
    public void setAttributes(TagAttribute[] tagAttributes)
    {
        this.attributes = tagAttributes;
    }

    /**
     * @return Returns the tagClass.
     */
    public String getTagClass()
    {
        return this.tagClass;
    }

    /**
     * @param className The tagClass to set.
     */
    public void setTagClass(String className)
    {
        this.tagClass = className;
    }
    /**
     * @return Returns the teiClass.
     */
    public String getTeiClass()
    {
        return this.teiClass;
    }
    /**
     * @param className The teiClass to set.
     */
    public void setTeiClass(String className)
    {
        this.teiClass = className;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE).append("name", this.name).append(
            "tagClass",
            this.tagClass).append("teiClass", this.teiClass).append("attributes", this.attributes).toString();
    }
}