/**
 * Copyright 2004 Fabrizio Giustina.
 *
 * Licensed under the Artistic License; you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://maven-taglib.sourceforge.net/license.html
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
package net.sf.maventaglib.checker;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;


/**
 * Javabean representing a tag attribute.
 * @author Fabrizio Giustina
 * @version $Revision: 1.3 $ ($Author: fgiust $)
 */
public class TagAttribute
{

    /**
     * Attribute name.
     */
    private String attributeName;

    /**
     * Atttribute type (can be null).
     */
    private String attributeType;

    /**
     * @return Returns the attribute name.
     */
    public String getAttributeName()
    {
        return this.attributeName;
    }

    /**
     * @param name attribute name.
     */
    public void setAttributeName(String name)
    {
        this.attributeName = name;
    }

    /**
     * @return Returns the attributeType.
     */
    public String getAttributeType()
    {
        return this.attributeType;
    }

    /**
     * @param type The attributeType to set.
     */
    public void setAttributeType(String type)
    {
        this.attributeType = type;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE)
            .append("attributeName", this.attributeName)
            .append("attributeType", this.attributeType)
            .toString();
    }
}