/**
 * Copyright 2004 Fabrizio Giustina.
 *
 * Licensed under the Artistic License; you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://maven-taglib.sourceforge.net/license.html
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
package net.sf.maventaglib.checker;


import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;


/**
 * Contains information about a single tag library.
 * @author Fabrizio Giustina
 * @version $Revision $ ($Author $)
 */
public class Tld
{

    /**
     * tag library shortname.
     */
    private String name;

    /**
     * tld file name.
     */
    private String filename;

    /**
     * List of tags.
     */
    private Tag[] tags;

    /**
     * @return Returns the filename.
     */
    public String getFilename()
    {
        return this.filename;
    }

    /**
     * @param file The filename to set.
     */
    public void setFilename(String file)
    {
        this.filename = file;
    }

    /**
     * Returns the shortname for this library.
     * @return shortname for this tag library
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Sets the shortname for this library.
     * @param tagLibName shortname for this tag library.
     */
    public void setName(String tagLibName)
    {
        this.name = tagLibName;
    }

    /**
     * Returnss the list of tags in this tag library.
     * @return list of tags in this tag library
     */
    public Tag[] getTags()
    {
        return this.tags;
    }

    /**
     * Sets the list of tags in this tag library.
     * @param tagList list of tags in this tag library
     */
    public void setTags(Tag[] tagList)
    {
        this.tags = tagList;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE)
            .append("name", this.name)
            .append("tags", this.tags)
            .toString();
    }
}