/*
 * Decompiled with CFR 0.152.
 */
package net.sf.maventaglib;

import java.io.File;
import net.sf.maventaglib.TaglibPlugin;

public class TaglibConvertPlugin
extends TaglibPlugin {
    private String outputVersion;
    private String inputVersion;

    public void setOutputVersion(String version) {
        this.outputVersion = version;
    }

    public void setInputVersion(String version) {
        this.inputVersion = version;
    }

    public void execute() throws Exception {
        if (this.inputVersion == null) {
            throw new IllegalArgumentException("Input version not set.");
        }
        if (this.outputVersion == null) {
            throw new IllegalArgumentException("Output version not set.");
        }
        String stylesheet = null;
        if ("1.2".equals(this.inputVersion) && "1.1".equals(this.outputVersion)) {
            stylesheet = "/tld1_2-tld1_1.xsl";
        } else if ("1.1".equals(this.inputVersion) && "1.2".equals(this.outputVersion)) {
            stylesheet = "/tld1_1-tld1_2.xsl";
        } else if ("1.2".equals(this.inputVersion) && "2.0".equals(this.outputVersion)) {
            stylesheet = "/tld1_2-tld2_0.xsl";
        } else {
            throw new IllegalArgumentException("Conversion from version " + this.inputVersion + " to " + this.outputVersion + " not supported");
        }
        File inputFile = new File(String.valueOf(this.srcDir) + "/" + this.tldSrc);
        File outputFile = new File(String.valueOf(this.outputDir) + "/" + this.tldOut);
        this.echo("Generating " + this.tldOut + " [" + this.outputVersion + "] from " + this.tldSrc + " [" + this.inputVersion + "]");
        this.applyXslt(inputFile, stylesheet, outputFile);
    }
}

