package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BoolValueBuilder extends BoolValueFluentImpl<BoolValueBuilder> implements VisitableBuilder<BoolValue,BoolValueBuilder>{

    BoolValueFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BoolValueBuilder(){
            this(true);
    }
    public BoolValueBuilder(Boolean validationEnabled){
            this(new BoolValue(), validationEnabled);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent){
            this(fluent, true);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BoolValue(), validationEnabled);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent,BoolValue instance){
            this(fluent, instance, true);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent,BoolValue instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public BoolValueBuilder(BoolValue instance){
            this(instance,true);
    }
    public BoolValueBuilder(BoolValue instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public BoolValueBuilder(Validator validator){
            this(new BoolValue(), true);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent,BoolValue instance,Validator validator){
            this.fluent = fluent; 
            fluent.withValue(instance.getValue()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BoolValueBuilder(BoolValue instance,Validator validator){
            this.fluent = this; 
            this.withValue(instance.getValue()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public BoolValue build(){
            BoolValue buildable = new BoolValue(fluent.isValue());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BoolValueBuilder that = (BoolValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
