package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TimeStampBuilder extends TimeStampFluentImpl<TimeStampBuilder> implements VisitableBuilder<TimeStamp,TimeStampBuilder>{

    TimeStampFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TimeStampBuilder(){
            this(true);
    }
    public TimeStampBuilder(Boolean validationEnabled){
            this(new TimeStamp(), validationEnabled);
    }
    public TimeStampBuilder(TimeStampFluent<?> fluent){
            this(fluent, true);
    }
    public TimeStampBuilder(TimeStampFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TimeStamp(), validationEnabled);
    }
    public TimeStampBuilder(TimeStampFluent<?> fluent,TimeStamp instance){
            this(fluent, instance, true);
    }
    public TimeStampBuilder(TimeStampFluent<?> fluent,TimeStamp instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNanos(instance.getNanos()); 
            fluent.withSeconds(instance.getSeconds()); 
            this.validationEnabled = validationEnabled; 
    }
    public TimeStampBuilder(TimeStamp instance){
            this(instance,true);
    }
    public TimeStampBuilder(TimeStamp instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNanos(instance.getNanos()); 
            this.withSeconds(instance.getSeconds()); 
            this.validationEnabled = validationEnabled; 
    }
    public TimeStampBuilder(Validator validator){
            this(new TimeStamp(), true);
    }
    public TimeStampBuilder(TimeStampFluent<?> fluent,TimeStamp instance,Validator validator){
            this.fluent = fluent; 
            fluent.withNanos(instance.getNanos()); 
            fluent.withSeconds(instance.getSeconds()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TimeStampBuilder(TimeStamp instance,Validator validator){
            this.fluent = this; 
            this.withNanos(instance.getNanos()); 
            this.withSeconds(instance.getSeconds()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TimeStamp build(){
            TimeStamp buildable = new TimeStamp(fluent.getNanos(),fluent.getSeconds());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TimeStampBuilder that = (TimeStampBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
