package me.snowdrop.istio.api;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TimeStampFluentImpl<A extends TimeStampFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TimeStampFluent<A>{

    private Integer nanos;
    private Long seconds;

    public TimeStampFluentImpl(){
    }
    public TimeStampFluentImpl(TimeStamp instance){
            this.withNanos(instance.getNanos()); 
            this.withSeconds(instance.getSeconds()); 
    }

    public Integer getNanos(){
            return this.nanos;
    }

    public A withNanos(Integer nanos){
            this.nanos=nanos; return (A) this;
    }

    public Boolean hasNanos(){
            return this.nanos != null;
    }

    public A withNewNanos(String arg1){
            return (A)withNanos(new Integer(arg1));
    }

    public A withNewNanos(int arg1){
            return (A)withNanos(new Integer(arg1));
    }

    public Long getSeconds(){
            return this.seconds;
    }

    public A withSeconds(Long seconds){
            this.seconds=seconds; return (A) this;
    }

    public Boolean hasSeconds(){
            return this.seconds != null;
    }

    public A withNewSeconds(String arg1){
            return (A)withSeconds(new Long(arg1));
    }

    public A withNewSeconds(long arg1){
            return (A)withSeconds(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TimeStampFluentImpl that = (TimeStampFluentImpl) o;
            if (nanos != null ? !nanos.equals(that.nanos) :that.nanos != null) return false;
            if (seconds != null ? !seconds.equals(that.seconds) :that.seconds != null) return false;
            return true;
    }




}
