package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class JwtParamsBuilder extends JwtParamsFluentImpl<JwtParamsBuilder> implements VisitableBuilder<JwtParams,JwtParamsBuilder>{

    JwtParamsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public JwtParamsBuilder(){
            this(true);
    }
    public JwtParamsBuilder(Boolean validationEnabled){
            this(new JwtParams(), validationEnabled);
    }
    public JwtParamsBuilder(JwtParamsFluent<?> fluent){
            this(fluent, true);
    }
    public JwtParamsBuilder(JwtParamsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JwtParams(), validationEnabled);
    }
    public JwtParamsBuilder(JwtParamsFluent<?> fluent,JwtParams instance){
            this(fluent, instance, true);
    }
    public JwtParamsBuilder(JwtParamsFluent<?> fluent,JwtParams instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withJwt(instance.getJwt()); 
            this.validationEnabled = validationEnabled; 
    }
    public JwtParamsBuilder(JwtParams instance){
            this(instance,true);
    }
    public JwtParamsBuilder(JwtParams instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withJwt(instance.getJwt()); 
            this.validationEnabled = validationEnabled; 
    }
    public JwtParamsBuilder(Validator validator){
            this(new JwtParams(), true);
    }
    public JwtParamsBuilder(JwtParamsFluent<?> fluent,JwtParams instance,Validator validator){
            this.fluent = fluent; 
            fluent.withJwt(instance.getJwt()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public JwtParamsBuilder(JwtParams instance,Validator validator){
            this.fluent = this; 
            this.withJwt(instance.getJwt()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public JwtParams build(){
            JwtParams buildable = new JwtParams(fluent.getJwt());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JwtParamsBuilder that = (JwtParamsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
