package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class JwtParamsFluentImpl<A extends JwtParamsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JwtParamsFluent<A>{

    private JwtBuilder jwt;

    public JwtParamsFluentImpl(){
    }
    public JwtParamsFluentImpl(JwtParams instance){
            this.withJwt(instance.getJwt()); 
    }

    
/**
 * This method has been deprecated, please use method buildJwt instead.
 * @return The buildable object.
 */
@Deprecated public Jwt getJwt(){
            return this.jwt!=null?this.jwt.build():null;
    }

    public Jwt buildJwt(){
            return this.jwt!=null?this.jwt.build():null;
    }

    public A withJwt(Jwt jwt){
            _visitables.remove(this.jwt);
            if (jwt!=null){ this.jwt= new JwtBuilder(jwt); _visitables.add(this.jwt);} return (A) this;
    }

    public Boolean hasJwt(){
            return this.jwt != null;
    }

    public JwtParamsFluent.JwtNested<A> withNewJwt(){
            return new JwtNestedImpl();
    }

    public JwtParamsFluent.JwtNested<A> withNewJwtLike(Jwt item){
            return new JwtNestedImpl(item);
    }

    public JwtParamsFluent.JwtNested<A> editJwt(){
            return withNewJwtLike(getJwt());
    }

    public JwtParamsFluent.JwtNested<A> editOrNewJwt(){
            return withNewJwtLike(getJwt() != null ? getJwt(): new JwtBuilder().build());
    }

    public JwtParamsFluent.JwtNested<A> editOrNewJwtLike(Jwt item){
            return withNewJwtLike(getJwt() != null ? getJwt(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JwtParamsFluentImpl that = (JwtParamsFluentImpl) o;
            if (jwt != null ? !jwt.equals(that.jwt) :that.jwt != null) return false;
            return true;
    }


    public class JwtNestedImpl<N> extends JwtFluentImpl<JwtParamsFluent.JwtNested<N>> implements JwtParamsFluent.JwtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JwtBuilder builder;
    
            JwtNestedImpl(Jwt item){
                    this.builder = new JwtBuilder(this, item);
            }
            JwtNestedImpl(){
                    this.builder = new JwtBuilder(this);
            }
    
    public N and(){
            return (N) JwtParamsFluentImpl.this.withJwt(builder.build());
    }
    public N endJwt(){
            return and();
    }

}


}
