package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class MutualTlsBuilder extends MutualTlsFluentImpl<MutualTlsBuilder> implements VisitableBuilder<MutualTls,MutualTlsBuilder>{

    MutualTlsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MutualTlsBuilder(){
            this(true);
    }
    public MutualTlsBuilder(Boolean validationEnabled){
            this(new MutualTls(), validationEnabled);
    }
    public MutualTlsBuilder(MutualTlsFluent<?> fluent){
            this(fluent, true);
    }
    public MutualTlsBuilder(MutualTlsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MutualTls(), validationEnabled);
    }
    public MutualTlsBuilder(MutualTlsFluent<?> fluent,MutualTls instance){
            this(fluent, instance, true);
    }
    public MutualTlsBuilder(MutualTlsFluent<?> fluent,MutualTls instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowTls(instance.getAllowTls()); 
            fluent.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public MutualTlsBuilder(MutualTls instance){
            this(instance,true);
    }
    public MutualTlsBuilder(MutualTls instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowTls(instance.getAllowTls()); 
            this.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public MutualTlsBuilder(Validator validator){
            this(new MutualTls(), true);
    }
    public MutualTlsBuilder(MutualTlsFluent<?> fluent,MutualTls instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAllowTls(instance.getAllowTls()); 
            fluent.withMode(instance.getMode()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public MutualTlsBuilder(MutualTls instance,Validator validator){
            this.fluent = this; 
            this.withAllowTls(instance.getAllowTls()); 
            this.withMode(instance.getMode()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public MutualTls build(){
            MutualTls buildable = new MutualTls(fluent.isAllowTls(),fluent.getMode());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MutualTlsBuilder that = (MutualTlsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
