package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PeerAuthenticationMethodBuilder extends PeerAuthenticationMethodFluentImpl<PeerAuthenticationMethodBuilder> implements VisitableBuilder<PeerAuthenticationMethod,PeerAuthenticationMethodBuilder>{

    PeerAuthenticationMethodFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PeerAuthenticationMethodBuilder(){
            this(true);
    }
    public PeerAuthenticationMethodBuilder(Boolean validationEnabled){
            this(new PeerAuthenticationMethod(), validationEnabled);
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethodFluent<?> fluent){
            this(fluent, true);
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethodFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PeerAuthenticationMethod(), validationEnabled);
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethodFluent<?> fluent,PeerAuthenticationMethod instance){
            this(fluent, instance, true);
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethodFluent<?> fluent,PeerAuthenticationMethod instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            this.validationEnabled = validationEnabled; 
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethod instance){
            this(instance,true);
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethod instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.validationEnabled = validationEnabled; 
    }
    public PeerAuthenticationMethodBuilder(Validator validator){
            this(new PeerAuthenticationMethod(), true);
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethodFluent<?> fluent,PeerAuthenticationMethod instance,Validator validator){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PeerAuthenticationMethodBuilder(PeerAuthenticationMethod instance,Validator validator){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PeerAuthenticationMethod build(){
            PeerAuthenticationMethod buildable = new PeerAuthenticationMethod(fluent.getParams());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PeerAuthenticationMethodBuilder that = (PeerAuthenticationMethodBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
