package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PortSelectorBuilder extends PortSelectorFluentImpl<PortSelectorBuilder> implements VisitableBuilder<PortSelector,PortSelectorBuilder>{

    PortSelectorFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PortSelectorBuilder(){
            this(true);
    }
    public PortSelectorBuilder(Boolean validationEnabled){
            this(new PortSelector(), validationEnabled);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PortSelector(), validationEnabled);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent,PortSelector instance){
            this(fluent, instance, true);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent,PortSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPort(instance.getPort()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortSelectorBuilder(PortSelector instance){
            this(instance,true);
    }
    public PortSelectorBuilder(PortSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPort(instance.getPort()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortSelectorBuilder(Validator validator){
            this(new PortSelector(), true);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent,PortSelector instance,Validator validator){
            this.fluent = fluent; 
            fluent.withPort(instance.getPort()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PortSelectorBuilder(PortSelector instance,Validator validator){
            this.fluent = this; 
            this.withPort(instance.getPort()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PortSelector build(){
            PortSelector buildable = new PortSelector(fluent.getPort());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortSelectorBuilder that = (PortSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
