package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TargetSelectorBuilder extends TargetSelectorFluentImpl<TargetSelectorBuilder> implements VisitableBuilder<TargetSelector,TargetSelectorBuilder>{

    TargetSelectorFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TargetSelectorBuilder(){
            this(true);
    }
    public TargetSelectorBuilder(Boolean validationEnabled){
            this(new TargetSelector(), validationEnabled);
    }
    public TargetSelectorBuilder(TargetSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public TargetSelectorBuilder(TargetSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TargetSelector(), validationEnabled);
    }
    public TargetSelectorBuilder(TargetSelectorFluent<?> fluent,TargetSelector instance){
            this(fluent, instance, true);
    }
    public TargetSelectorBuilder(TargetSelectorFluent<?> fluent,TargetSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPorts(instance.getPorts()); 
            this.validationEnabled = validationEnabled; 
    }
    public TargetSelectorBuilder(TargetSelector instance){
            this(instance,true);
    }
    public TargetSelectorBuilder(TargetSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPorts(instance.getPorts()); 
            this.validationEnabled = validationEnabled; 
    }
    public TargetSelectorBuilder(Validator validator){
            this(new TargetSelector(), true);
    }
    public TargetSelectorBuilder(TargetSelectorFluent<?> fluent,TargetSelector instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPorts(instance.getPorts()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TargetSelectorBuilder(TargetSelector instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPorts(instance.getPorts()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TargetSelector build(){
            TargetSelector buildable = new TargetSelector(fluent.getName(),fluent.getPorts());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TargetSelectorBuilder that = (TargetSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
