package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TargetSelectorFluentImpl<A extends TargetSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TargetSelectorFluent<A>{

    private String name;
    private List<PortSelectorBuilder> ports;

    public TargetSelectorFluentImpl(){
    }
    public TargetSelectorFluentImpl(TargetSelector instance){
            this.withName(instance.getName()); 
            this.withPorts(instance.getPorts()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A addToPorts(int index,PortSelector item){
            if (this.ports == null) {this.ports = new ArrayList<PortSelectorBuilder>();}
            PortSelectorBuilder builder = new PortSelectorBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,PortSelector item){
            if (this.ports == null) {this.ports = new ArrayList<PortSelectorBuilder>();}
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(PortSelector... items){
            if (this.ports == null) {this.ports = new ArrayList<PortSelectorBuilder>();}
            for (PortSelector item : items) {PortSelectorBuilder builder = new PortSelectorBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<PortSelector> items){
            if (this.ports == null) {this.ports = new ArrayList<PortSelectorBuilder>();}
            for (PortSelector item : items) {PortSelectorBuilder builder = new PortSelectorBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(PortSelector... items){
            for (PortSelector item : items) {PortSelectorBuilder builder = new PortSelectorBuilder(item);_visitables.remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<PortSelector> items){
            for (PortSelector item : items) {PortSelectorBuilder builder = new PortSelectorBuilder(item);_visitables.remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<PortSelector> getPorts(){
            return build(ports);
    }

    public List<PortSelector> buildPorts(){
            return build(ports);
    }

    public PortSelector buildPort(int index){
            return this.ports.get(index).build();
    }

    public PortSelector buildFirstPort(){
            return this.ports.get(0).build();
    }

    public PortSelector buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public PortSelector buildMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate){
            for (PortSelectorBuilder item: ports) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withPorts(List<PortSelector> ports){
            if (this.ports != null) { _visitables.removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<PortSelectorBuilder>(); for (PortSelector item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(PortSelector... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (PortSelector item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public TargetSelectorFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public TargetSelectorFluent.PortsNested<A> addNewPortLike(PortSelector item){
            return new PortsNestedImpl(-1, item);
    }

    public TargetSelectorFluent.PortsNested<A> setNewPortLike(int index,PortSelector item){
            return new PortsNestedImpl(index, item);
    }

    public TargetSelectorFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public TargetSelectorFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public TargetSelectorFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public TargetSelectorFluent.PortsNested<A> editMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TargetSelectorFluentImpl that = (TargetSelectorFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            return true;
    }


    public class PortsNestedImpl<N> extends PortSelectorFluentImpl<TargetSelectorFluent.PortsNested<N>> implements TargetSelectorFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PortSelectorBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,PortSelector item){
                    this.index = index;
                    this.builder = new PortSelectorBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new PortSelectorBuilder(this);
            }
    
    public N and(){
            return (N) TargetSelectorFluentImpl.this.setToPorts(index, builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
