package me.snowdrop.istio.api.cexl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TypedValueBuilder extends TypedValueFluentImpl<TypedValueBuilder> implements VisitableBuilder<TypedValue,TypedValueBuilder>{

    TypedValueFluent<?> fluent;
    Boolean validationEnabled;

    public TypedValueBuilder(){
            this(true);
    }
    public TypedValueBuilder(Boolean validationEnabled){
            this.fluent = this; this.validationEnabled=validationEnabled;
    }
    public TypedValueBuilder(TypedValueFluent<?> fluent){
            this(fluent, true);
    }
    public TypedValueBuilder(TypedValueFluent<?> fluent,Boolean validationEnabled){
            this.fluent = fluent; this.validationEnabled=validationEnabled;
    }
    public TypedValueBuilder(TypedValueFluent<?> fluent,TypedValue instance){
            this(fluent, instance, true);
    }
    public TypedValueBuilder(TypedValueFluent<?> fluent,TypedValue instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withType(instance.getType()); 
            fluent.withExpression(instance.getExpression()); 
            this.validationEnabled = validationEnabled; 
    }
    public TypedValueBuilder(TypedValue instance){
            this(instance,true);
    }
    public TypedValueBuilder(TypedValue instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withType(instance.getType()); 
            this.withExpression(instance.getExpression()); 
            this.validationEnabled = validationEnabled; 
    }

    public TypedValue build(){
            TypedValue buildable = new TypedValue(fluent.getType(),fluent.getExpression());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TypedValueBuilder that = (TypedValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
