
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "accessLogFile",
    "authPolicy",
    "connectTimeout",
    "defaultConfig",
    "disablePolicyChecks",
    "enableClientSidePolicyCheck",
    "enableTracing",
    "ingressClass",
    "ingressControllerMode",
    "ingressService",
    "mixerAddress",
    "mixerCheckServer",
    "mixerReportServer",
    "outboundTrafficPolicy",
    "policyCheckFailOpen",
    "proxyHttpPort",
    "proxyListenPort",
    "rdsRefreshDelay",
    "sdsRefreshDelay",
    "sdsUdsPath"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MeshConfig implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("accessLogFile")
    @JsonPropertyDescription("")
    private String accessLogFile;
    @JsonProperty("authPolicy")
    private AuthenticationPolicy authPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    @JsonPropertyDescription("")
    @Valid
    private Duration connectTimeout;
    /**
     * 
     * 
     */
    @JsonProperty("defaultConfig")
    @JsonPropertyDescription("")
    @Valid
    private ProxyConfig defaultConfig;
    /**
     * 
     * 
     */
    @JsonProperty("disablePolicyChecks")
    @JsonPropertyDescription("")
    private Boolean disablePolicyChecks;
    /**
     * 
     * 
     */
    @JsonProperty("enableClientSidePolicyCheck")
    @JsonPropertyDescription("")
    private Boolean enableClientSidePolicyCheck;
    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    @JsonPropertyDescription("")
    private Boolean enableTracing;
    /**
     * 
     * 
     */
    @JsonProperty("ingressClass")
    @JsonPropertyDescription("")
    private String ingressClass;
    @JsonProperty("ingressControllerMode")
    private IngressControllerMode ingressControllerMode;
    /**
     * 
     * 
     */
    @JsonProperty("ingressService")
    @JsonPropertyDescription("")
    private String ingressService;
    /**
     * 
     * 
     */
    @JsonProperty("mixerAddress")
    @JsonPropertyDescription("")
    private String mixerAddress;
    /**
     * 
     * 
     */
    @JsonProperty("mixerCheckServer")
    @JsonPropertyDescription("")
    private String mixerCheckServer;
    /**
     * 
     * 
     */
    @JsonProperty("mixerReportServer")
    @JsonPropertyDescription("")
    private String mixerReportServer;
    /**
     * 
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    @JsonPropertyDescription("")
    @Valid
    private OutboundTrafficPolicy outboundTrafficPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("policyCheckFailOpen")
    @JsonPropertyDescription("")
    private Boolean policyCheckFailOpen;
    /**
     * 
     * 
     */
    @JsonProperty("proxyHttpPort")
    @JsonPropertyDescription("")
    private Integer proxyHttpPort;
    /**
     * 
     * 
     */
    @JsonProperty("proxyListenPort")
    @JsonPropertyDescription("")
    private Integer proxyListenPort;
    /**
     * 
     * 
     */
    @JsonProperty("rdsRefreshDelay")
    @JsonPropertyDescription("")
    @Valid
    private Duration rdsRefreshDelay;
    /**
     * 
     * 
     */
    @JsonProperty("sdsRefreshDelay")
    @JsonPropertyDescription("")
    @Valid
    private Duration sdsRefreshDelay;
    /**
     * 
     * 
     */
    @JsonProperty("sdsUdsPath")
    @JsonPropertyDescription("")
    private String sdsUdsPath;
    private final static long serialVersionUID = 3676191682809809391L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MeshConfig() {
    }

    /**
     * 
     * @param proxyListenPort
     * @param policyCheckFailOpen
     * @param accessLogFile
     * @param enableClientSidePolicyCheck
     * @param enableTracing
     * @param mixerCheckServer
     * @param authPolicy
     * @param ingressClass
     * @param ingressControllerMode
     * @param mixerReportServer
     * @param outboundTrafficPolicy
     * @param ingressService
     * @param proxyHttpPort
     * @param disablePolicyChecks
     * @param rdsRefreshDelay
     * @param sdsUdsPath
     * @param defaultConfig
     * @param connectTimeout
     * @param mixerAddress
     * @param sdsRefreshDelay
     */
    public MeshConfig(String accessLogFile, AuthenticationPolicy authPolicy, Duration connectTimeout, ProxyConfig defaultConfig, Boolean disablePolicyChecks, Boolean enableClientSidePolicyCheck, Boolean enableTracing, String ingressClass, IngressControllerMode ingressControllerMode, String ingressService, String mixerAddress, String mixerCheckServer, String mixerReportServer, OutboundTrafficPolicy outboundTrafficPolicy, Boolean policyCheckFailOpen, Integer proxyHttpPort, Integer proxyListenPort, Duration rdsRefreshDelay, Duration sdsRefreshDelay, String sdsUdsPath) {
        super();
        this.accessLogFile = accessLogFile;
        this.authPolicy = authPolicy;
        this.connectTimeout = connectTimeout;
        this.defaultConfig = defaultConfig;
        this.disablePolicyChecks = disablePolicyChecks;
        this.enableClientSidePolicyCheck = enableClientSidePolicyCheck;
        this.enableTracing = enableTracing;
        this.ingressClass = ingressClass;
        this.ingressControllerMode = ingressControllerMode;
        this.ingressService = ingressService;
        this.mixerAddress = mixerAddress;
        this.mixerCheckServer = mixerCheckServer;
        this.mixerReportServer = mixerReportServer;
        this.outboundTrafficPolicy = outboundTrafficPolicy;
        this.policyCheckFailOpen = policyCheckFailOpen;
        this.proxyHttpPort = proxyHttpPort;
        this.proxyListenPort = proxyListenPort;
        this.rdsRefreshDelay = rdsRefreshDelay;
        this.sdsRefreshDelay = sdsRefreshDelay;
        this.sdsUdsPath = sdsUdsPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessLogFile")
    public String getAccessLogFile() {
        return accessLogFile;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessLogFile")
    public void setAccessLogFile(String accessLogFile) {
        this.accessLogFile = accessLogFile;
    }

    @JsonProperty("authPolicy")
    public AuthenticationPolicy getAuthPolicy() {
        return authPolicy;
    }

    @JsonProperty("authPolicy")
    public void setAuthPolicy(AuthenticationPolicy authPolicy) {
        this.authPolicy = authPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultConfig")
    public ProxyConfig getDefaultConfig() {
        return defaultConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultConfig")
    public void setDefaultConfig(ProxyConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("disablePolicyChecks")
    public Boolean getDisablePolicyChecks() {
        return disablePolicyChecks;
    }

    /**
     * 
     * 
     */
    @JsonProperty("disablePolicyChecks")
    public void setDisablePolicyChecks(Boolean disablePolicyChecks) {
        this.disablePolicyChecks = disablePolicyChecks;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableClientSidePolicyCheck")
    public Boolean getEnableClientSidePolicyCheck() {
        return enableClientSidePolicyCheck;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableClientSidePolicyCheck")
    public void setEnableClientSidePolicyCheck(Boolean enableClientSidePolicyCheck) {
        this.enableClientSidePolicyCheck = enableClientSidePolicyCheck;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    public Boolean getEnableTracing() {
        return enableTracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    public void setEnableTracing(Boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressClass")
    public String getIngressClass() {
        return ingressClass;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressClass")
    public void setIngressClass(String ingressClass) {
        this.ingressClass = ingressClass;
    }

    @JsonProperty("ingressControllerMode")
    public IngressControllerMode getIngressControllerMode() {
        return ingressControllerMode;
    }

    @JsonProperty("ingressControllerMode")
    public void setIngressControllerMode(IngressControllerMode ingressControllerMode) {
        this.ingressControllerMode = ingressControllerMode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressService")
    public String getIngressService() {
        return ingressService;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressService")
    public void setIngressService(String ingressService) {
        this.ingressService = ingressService;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerAddress")
    public String getMixerAddress() {
        return mixerAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerAddress")
    public void setMixerAddress(String mixerAddress) {
        this.mixerAddress = mixerAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerCheckServer")
    public String getMixerCheckServer() {
        return mixerCheckServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerCheckServer")
    public void setMixerCheckServer(String mixerCheckServer) {
        this.mixerCheckServer = mixerCheckServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerReportServer")
    public String getMixerReportServer() {
        return mixerReportServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerReportServer")
    public void setMixerReportServer(String mixerReportServer) {
        this.mixerReportServer = mixerReportServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    public OutboundTrafficPolicy getOutboundTrafficPolicy() {
        return outboundTrafficPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    public void setOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy) {
        this.outboundTrafficPolicy = outboundTrafficPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("policyCheckFailOpen")
    public Boolean getPolicyCheckFailOpen() {
        return policyCheckFailOpen;
    }

    /**
     * 
     * 
     */
    @JsonProperty("policyCheckFailOpen")
    public void setPolicyCheckFailOpen(Boolean policyCheckFailOpen) {
        this.policyCheckFailOpen = policyCheckFailOpen;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyHttpPort")
    public Integer getProxyHttpPort() {
        return proxyHttpPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyHttpPort")
    public void setProxyHttpPort(Integer proxyHttpPort) {
        this.proxyHttpPort = proxyHttpPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyListenPort")
    public Integer getProxyListenPort() {
        return proxyListenPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyListenPort")
    public void setProxyListenPort(Integer proxyListenPort) {
        this.proxyListenPort = proxyListenPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rdsRefreshDelay")
    public Duration getRdsRefreshDelay() {
        return rdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rdsRefreshDelay")
    public void setRdsRefreshDelay(Duration rdsRefreshDelay) {
        this.rdsRefreshDelay = rdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsRefreshDelay")
    public Duration getSdsRefreshDelay() {
        return sdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsRefreshDelay")
    public void setSdsRefreshDelay(Duration sdsRefreshDelay) {
        this.sdsRefreshDelay = sdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsUdsPath")
    public String getSdsUdsPath() {
        return sdsUdsPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsUdsPath")
    public void setSdsUdsPath(String sdsUdsPath) {
        this.sdsUdsPath = sdsUdsPath;
    }

}
