package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class MeshConfigBuilder extends MeshConfigFluentImpl<MeshConfigBuilder> implements VisitableBuilder<MeshConfig,MeshConfigBuilder>{

    MeshConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MeshConfigBuilder(){
            this(true);
    }
    public MeshConfigBuilder(Boolean validationEnabled){
            this(new MeshConfig(), validationEnabled);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent){
            this(fluent, true);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MeshConfig(), validationEnabled);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,MeshConfig instance){
            this(fluent, instance, true);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,MeshConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessLogFile(instance.getAccessLogFile()); 
            fluent.withAuthPolicy(instance.getAuthPolicy()); 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withDefaultConfig(instance.getDefaultConfig()); 
            fluent.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            fluent.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            fluent.withEnableTracing(instance.getEnableTracing()); 
            fluent.withIngressClass(instance.getIngressClass()); 
            fluent.withIngressControllerMode(instance.getIngressControllerMode()); 
            fluent.withIngressService(instance.getIngressService()); 
            fluent.withMixerAddress(instance.getMixerAddress()); 
            fluent.withMixerCheckServer(instance.getMixerCheckServer()); 
            fluent.withMixerReportServer(instance.getMixerReportServer()); 
            fluent.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            fluent.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            fluent.withProxyHttpPort(instance.getProxyHttpPort()); 
            fluent.withProxyListenPort(instance.getProxyListenPort()); 
            fluent.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            fluent.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            fluent.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public MeshConfigBuilder(MeshConfig instance){
            this(instance,true);
    }
    public MeshConfigBuilder(MeshConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessLogFile(instance.getAccessLogFile()); 
            this.withAuthPolicy(instance.getAuthPolicy()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withDefaultConfig(instance.getDefaultConfig()); 
            this.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            this.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withIngressClass(instance.getIngressClass()); 
            this.withIngressControllerMode(instance.getIngressControllerMode()); 
            this.withIngressService(instance.getIngressService()); 
            this.withMixerAddress(instance.getMixerAddress()); 
            this.withMixerCheckServer(instance.getMixerCheckServer()); 
            this.withMixerReportServer(instance.getMixerReportServer()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            this.withProxyHttpPort(instance.getProxyHttpPort()); 
            this.withProxyListenPort(instance.getProxyListenPort()); 
            this.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            this.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            this.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public MeshConfigBuilder(Validator validator){
            this(new MeshConfig(), true);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,MeshConfig instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAccessLogFile(instance.getAccessLogFile()); 
            fluent.withAuthPolicy(instance.getAuthPolicy()); 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withDefaultConfig(instance.getDefaultConfig()); 
            fluent.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            fluent.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            fluent.withEnableTracing(instance.getEnableTracing()); 
            fluent.withIngressClass(instance.getIngressClass()); 
            fluent.withIngressControllerMode(instance.getIngressControllerMode()); 
            fluent.withIngressService(instance.getIngressService()); 
            fluent.withMixerAddress(instance.getMixerAddress()); 
            fluent.withMixerCheckServer(instance.getMixerCheckServer()); 
            fluent.withMixerReportServer(instance.getMixerReportServer()); 
            fluent.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            fluent.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            fluent.withProxyHttpPort(instance.getProxyHttpPort()); 
            fluent.withProxyListenPort(instance.getProxyListenPort()); 
            fluent.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            fluent.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            fluent.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public MeshConfigBuilder(MeshConfig instance,Validator validator){
            this.fluent = this; 
            this.withAccessLogFile(instance.getAccessLogFile()); 
            this.withAuthPolicy(instance.getAuthPolicy()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withDefaultConfig(instance.getDefaultConfig()); 
            this.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            this.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withIngressClass(instance.getIngressClass()); 
            this.withIngressControllerMode(instance.getIngressControllerMode()); 
            this.withIngressService(instance.getIngressService()); 
            this.withMixerAddress(instance.getMixerAddress()); 
            this.withMixerCheckServer(instance.getMixerCheckServer()); 
            this.withMixerReportServer(instance.getMixerReportServer()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            this.withProxyHttpPort(instance.getProxyHttpPort()); 
            this.withProxyListenPort(instance.getProxyListenPort()); 
            this.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            this.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            this.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public MeshConfig build(){
            MeshConfig buildable = new MeshConfig(fluent.getAccessLogFile(),fluent.getAuthPolicy(),fluent.getConnectTimeout(),fluent.getDefaultConfig(),fluent.isDisablePolicyChecks(),fluent.isEnableClientSidePolicyCheck(),fluent.isEnableTracing(),fluent.getIngressClass(),fluent.getIngressControllerMode(),fluent.getIngressService(),fluent.getMixerAddress(),fluent.getMixerCheckServer(),fluent.getMixerReportServer(),fluent.getOutboundTrafficPolicy(),fluent.isPolicyCheckFailOpen(),fluent.getProxyHttpPort(),fluent.getProxyListenPort(),fluent.getRdsRefreshDelay(),fluent.getSdsRefreshDelay(),fluent.getSdsUdsPath());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MeshConfigBuilder that = (MeshConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
