package me.snowdrop.istio.api.mesh.v1alpha1;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class MeshConfigFluentImpl<A extends MeshConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MeshConfigFluent<A>{

    private String accessLogFile;
    private AuthenticationPolicy authPolicy;
    private DurationBuilder connectTimeout;
    private ProxyConfigBuilder defaultConfig;
    private Boolean disablePolicyChecks;
    private Boolean enableClientSidePolicyCheck;
    private Boolean enableTracing;
    private String ingressClass;
    private IngressControllerMode ingressControllerMode;
    private String ingressService;
    private String mixerAddress;
    private String mixerCheckServer;
    private String mixerReportServer;
    private OutboundTrafficPolicyBuilder outboundTrafficPolicy;
    private Boolean policyCheckFailOpen;
    private Integer proxyHttpPort;
    private Integer proxyListenPort;
    private DurationBuilder rdsRefreshDelay;
    private DurationBuilder sdsRefreshDelay;
    private String sdsUdsPath;

    public MeshConfigFluentImpl(){
    }
    public MeshConfigFluentImpl(MeshConfig instance){
            this.withAccessLogFile(instance.getAccessLogFile()); 
            this.withAuthPolicy(instance.getAuthPolicy()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withDefaultConfig(instance.getDefaultConfig()); 
            this.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            this.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withIngressClass(instance.getIngressClass()); 
            this.withIngressControllerMode(instance.getIngressControllerMode()); 
            this.withIngressService(instance.getIngressService()); 
            this.withMixerAddress(instance.getMixerAddress()); 
            this.withMixerCheckServer(instance.getMixerCheckServer()); 
            this.withMixerReportServer(instance.getMixerReportServer()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            this.withProxyHttpPort(instance.getProxyHttpPort()); 
            this.withProxyListenPort(instance.getProxyListenPort()); 
            this.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            this.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            this.withSdsUdsPath(instance.getSdsUdsPath()); 
    }

    public String getAccessLogFile(){
            return this.accessLogFile;
    }

    public A withAccessLogFile(String accessLogFile){
            this.accessLogFile=accessLogFile; return (A) this;
    }

    public Boolean hasAccessLogFile(){
            return this.accessLogFile != null;
    }

    public AuthenticationPolicy getAuthPolicy(){
            return this.authPolicy;
    }

    public A withAuthPolicy(AuthenticationPolicy authPolicy){
            this.authPolicy=authPolicy; return (A) this;
    }

    public Boolean hasAuthPolicy(){
            return this.authPolicy != null;
    }

    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public Duration buildConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public A withConnectTimeout(Duration connectTimeout){
            _visitables.remove(this.connectTimeout);
            if (connectTimeout!=null){ this.connectTimeout= new DurationBuilder(connectTimeout); _visitables.add(this.connectTimeout);} return (A) this;
    }

    public Boolean hasConnectTimeout(){
            return this.connectTimeout != null;
    }

    public A withNewConnectTimeout(Integer nanos,Long seconds){
            return (A)withConnectTimeout(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeout(){
            return new ConnectTimeoutNestedImpl();
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item){
            return new ConnectTimeoutNestedImpl(item);
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout());
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): new DurationBuilder().build());
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDefaultConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getDefaultConfig(){
            return this.defaultConfig!=null?this.defaultConfig.build():null;
    }

    public ProxyConfig buildDefaultConfig(){
            return this.defaultConfig!=null?this.defaultConfig.build():null;
    }

    public A withDefaultConfig(ProxyConfig defaultConfig){
            _visitables.remove(this.defaultConfig);
            if (defaultConfig!=null){ this.defaultConfig= new ProxyConfigBuilder(defaultConfig); _visitables.add(this.defaultConfig);} return (A) this;
    }

    public Boolean hasDefaultConfig(){
            return this.defaultConfig != null;
    }

    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfig(){
            return new DefaultConfigNestedImpl();
    }

    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfigLike(ProxyConfig item){
            return new DefaultConfigNestedImpl(item);
    }

    public MeshConfigFluent.DefaultConfigNested<A> editDefaultConfig(){
            return withNewDefaultConfigLike(getDefaultConfig());
    }

    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfig(){
            return withNewDefaultConfigLike(getDefaultConfig() != null ? getDefaultConfig(): new ProxyConfigBuilder().build());
    }

    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfigLike(ProxyConfig item){
            return withNewDefaultConfigLike(getDefaultConfig() != null ? getDefaultConfig(): item);
    }

    public Boolean isDisablePolicyChecks(){
            return this.disablePolicyChecks;
    }

    public A withDisablePolicyChecks(Boolean disablePolicyChecks){
            this.disablePolicyChecks=disablePolicyChecks; return (A) this;
    }

    public Boolean hasDisablePolicyChecks(){
            return this.disablePolicyChecks != null;
    }

    public A withNewDisablePolicyChecks(String arg1){
            return (A)withDisablePolicyChecks(new Boolean(arg1));
    }

    public A withNewDisablePolicyChecks(boolean arg1){
            return (A)withDisablePolicyChecks(new Boolean(arg1));
    }

    public Boolean isEnableClientSidePolicyCheck(){
            return this.enableClientSidePolicyCheck;
    }

    public A withEnableClientSidePolicyCheck(Boolean enableClientSidePolicyCheck){
            this.enableClientSidePolicyCheck=enableClientSidePolicyCheck; return (A) this;
    }

    public Boolean hasEnableClientSidePolicyCheck(){
            return this.enableClientSidePolicyCheck != null;
    }

    public A withNewEnableClientSidePolicyCheck(String arg1){
            return (A)withEnableClientSidePolicyCheck(new Boolean(arg1));
    }

    public A withNewEnableClientSidePolicyCheck(boolean arg1){
            return (A)withEnableClientSidePolicyCheck(new Boolean(arg1));
    }

    public Boolean isEnableTracing(){
            return this.enableTracing;
    }

    public A withEnableTracing(Boolean enableTracing){
            this.enableTracing=enableTracing; return (A) this;
    }

    public Boolean hasEnableTracing(){
            return this.enableTracing != null;
    }

    public A withNewEnableTracing(String arg1){
            return (A)withEnableTracing(new Boolean(arg1));
    }

    public A withNewEnableTracing(boolean arg1){
            return (A)withEnableTracing(new Boolean(arg1));
    }

    public String getIngressClass(){
            return this.ingressClass;
    }

    public A withIngressClass(String ingressClass){
            this.ingressClass=ingressClass; return (A) this;
    }

    public Boolean hasIngressClass(){
            return this.ingressClass != null;
    }

    public IngressControllerMode getIngressControllerMode(){
            return this.ingressControllerMode;
    }

    public A withIngressControllerMode(IngressControllerMode ingressControllerMode){
            this.ingressControllerMode=ingressControllerMode; return (A) this;
    }

    public Boolean hasIngressControllerMode(){
            return this.ingressControllerMode != null;
    }

    public String getIngressService(){
            return this.ingressService;
    }

    public A withIngressService(String ingressService){
            this.ingressService=ingressService; return (A) this;
    }

    public Boolean hasIngressService(){
            return this.ingressService != null;
    }

    public String getMixerAddress(){
            return this.mixerAddress;
    }

    public A withMixerAddress(String mixerAddress){
            this.mixerAddress=mixerAddress; return (A) this;
    }

    public Boolean hasMixerAddress(){
            return this.mixerAddress != null;
    }

    public String getMixerCheckServer(){
            return this.mixerCheckServer;
    }

    public A withMixerCheckServer(String mixerCheckServer){
            this.mixerCheckServer=mixerCheckServer; return (A) this;
    }

    public Boolean hasMixerCheckServer(){
            return this.mixerCheckServer != null;
    }

    public String getMixerReportServer(){
            return this.mixerReportServer;
    }

    public A withMixerReportServer(String mixerReportServer){
            this.mixerReportServer=mixerReportServer; return (A) this;
    }

    public Boolean hasMixerReportServer(){
            return this.mixerReportServer != null;
    }

    
/**
 * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public OutboundTrafficPolicy getOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public OutboundTrafficPolicy buildOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public A withOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy){
            _visitables.remove(this.outboundTrafficPolicy);
            if (outboundTrafficPolicy!=null){ this.outboundTrafficPolicy= new OutboundTrafficPolicyBuilder(outboundTrafficPolicy); _visitables.add(this.outboundTrafficPolicy);} return (A) this;
    }

    public Boolean hasOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy != null;
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy(){
            return new OutboundTrafficPolicyNestedImpl();
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item){
            return new OutboundTrafficPolicyNestedImpl(item);
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy());
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): new OutboundTrafficPolicyBuilder().build());
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): item);
    }

    public Boolean isPolicyCheckFailOpen(){
            return this.policyCheckFailOpen;
    }

    public A withPolicyCheckFailOpen(Boolean policyCheckFailOpen){
            this.policyCheckFailOpen=policyCheckFailOpen; return (A) this;
    }

    public Boolean hasPolicyCheckFailOpen(){
            return this.policyCheckFailOpen != null;
    }

    public A withNewPolicyCheckFailOpen(String arg1){
            return (A)withPolicyCheckFailOpen(new Boolean(arg1));
    }

    public A withNewPolicyCheckFailOpen(boolean arg1){
            return (A)withPolicyCheckFailOpen(new Boolean(arg1));
    }

    public Integer getProxyHttpPort(){
            return this.proxyHttpPort;
    }

    public A withProxyHttpPort(Integer proxyHttpPort){
            this.proxyHttpPort=proxyHttpPort; return (A) this;
    }

    public Boolean hasProxyHttpPort(){
            return this.proxyHttpPort != null;
    }

    public A withNewProxyHttpPort(String arg1){
            return (A)withProxyHttpPort(new Integer(arg1));
    }

    public A withNewProxyHttpPort(int arg1){
            return (A)withProxyHttpPort(new Integer(arg1));
    }

    public Integer getProxyListenPort(){
            return this.proxyListenPort;
    }

    public A withProxyListenPort(Integer proxyListenPort){
            this.proxyListenPort=proxyListenPort; return (A) this;
    }

    public Boolean hasProxyListenPort(){
            return this.proxyListenPort != null;
    }

    public A withNewProxyListenPort(String arg1){
            return (A)withProxyListenPort(new Integer(arg1));
    }

    public A withNewProxyListenPort(int arg1){
            return (A)withProxyListenPort(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getRdsRefreshDelay(){
            return this.rdsRefreshDelay!=null?this.rdsRefreshDelay.build():null;
    }

    public Duration buildRdsRefreshDelay(){
            return this.rdsRefreshDelay!=null?this.rdsRefreshDelay.build():null;
    }

    public A withRdsRefreshDelay(Duration rdsRefreshDelay){
            _visitables.remove(this.rdsRefreshDelay);
            if (rdsRefreshDelay!=null){ this.rdsRefreshDelay= new DurationBuilder(rdsRefreshDelay); _visitables.add(this.rdsRefreshDelay);} return (A) this;
    }

    public Boolean hasRdsRefreshDelay(){
            return this.rdsRefreshDelay != null;
    }

    public A withNewRdsRefreshDelay(Integer nanos,Long seconds){
            return (A)withRdsRefreshDelay(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelay(){
            return new RdsRefreshDelayNestedImpl();
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelayLike(Duration item){
            return new RdsRefreshDelayNestedImpl(item);
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editRdsRefreshDelay(){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay());
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelay(){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay() != null ? getRdsRefreshDelay(): new DurationBuilder().build());
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelayLike(Duration item){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay() != null ? getRdsRefreshDelay(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getSdsRefreshDelay(){
            return this.sdsRefreshDelay!=null?this.sdsRefreshDelay.build():null;
    }

    public Duration buildSdsRefreshDelay(){
            return this.sdsRefreshDelay!=null?this.sdsRefreshDelay.build():null;
    }

    public A withSdsRefreshDelay(Duration sdsRefreshDelay){
            _visitables.remove(this.sdsRefreshDelay);
            if (sdsRefreshDelay!=null){ this.sdsRefreshDelay= new DurationBuilder(sdsRefreshDelay); _visitables.add(this.sdsRefreshDelay);} return (A) this;
    }

    public Boolean hasSdsRefreshDelay(){
            return this.sdsRefreshDelay != null;
    }

    public A withNewSdsRefreshDelay(Integer nanos,Long seconds){
            return (A)withSdsRefreshDelay(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelay(){
            return new SdsRefreshDelayNestedImpl();
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelayLike(Duration item){
            return new SdsRefreshDelayNestedImpl(item);
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editSdsRefreshDelay(){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay());
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelay(){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay() != null ? getSdsRefreshDelay(): new DurationBuilder().build());
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelayLike(Duration item){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay() != null ? getSdsRefreshDelay(): item);
    }

    public String getSdsUdsPath(){
            return this.sdsUdsPath;
    }

    public A withSdsUdsPath(String sdsUdsPath){
            this.sdsUdsPath=sdsUdsPath; return (A) this;
    }

    public Boolean hasSdsUdsPath(){
            return this.sdsUdsPath != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MeshConfigFluentImpl that = (MeshConfigFluentImpl) o;
            if (accessLogFile != null ? !accessLogFile.equals(that.accessLogFile) :that.accessLogFile != null) return false;
            if (authPolicy != null ? !authPolicy.equals(that.authPolicy) :that.authPolicy != null) return false;
            if (connectTimeout != null ? !connectTimeout.equals(that.connectTimeout) :that.connectTimeout != null) return false;
            if (defaultConfig != null ? !defaultConfig.equals(that.defaultConfig) :that.defaultConfig != null) return false;
            if (disablePolicyChecks != null ? !disablePolicyChecks.equals(that.disablePolicyChecks) :that.disablePolicyChecks != null) return false;
            if (enableClientSidePolicyCheck != null ? !enableClientSidePolicyCheck.equals(that.enableClientSidePolicyCheck) :that.enableClientSidePolicyCheck != null) return false;
            if (enableTracing != null ? !enableTracing.equals(that.enableTracing) :that.enableTracing != null) return false;
            if (ingressClass != null ? !ingressClass.equals(that.ingressClass) :that.ingressClass != null) return false;
            if (ingressControllerMode != null ? !ingressControllerMode.equals(that.ingressControllerMode) :that.ingressControllerMode != null) return false;
            if (ingressService != null ? !ingressService.equals(that.ingressService) :that.ingressService != null) return false;
            if (mixerAddress != null ? !mixerAddress.equals(that.mixerAddress) :that.mixerAddress != null) return false;
            if (mixerCheckServer != null ? !mixerCheckServer.equals(that.mixerCheckServer) :that.mixerCheckServer != null) return false;
            if (mixerReportServer != null ? !mixerReportServer.equals(that.mixerReportServer) :that.mixerReportServer != null) return false;
            if (outboundTrafficPolicy != null ? !outboundTrafficPolicy.equals(that.outboundTrafficPolicy) :that.outboundTrafficPolicy != null) return false;
            if (policyCheckFailOpen != null ? !policyCheckFailOpen.equals(that.policyCheckFailOpen) :that.policyCheckFailOpen != null) return false;
            if (proxyHttpPort != null ? !proxyHttpPort.equals(that.proxyHttpPort) :that.proxyHttpPort != null) return false;
            if (proxyListenPort != null ? !proxyListenPort.equals(that.proxyListenPort) :that.proxyListenPort != null) return false;
            if (rdsRefreshDelay != null ? !rdsRefreshDelay.equals(that.rdsRefreshDelay) :that.rdsRefreshDelay != null) return false;
            if (sdsRefreshDelay != null ? !sdsRefreshDelay.equals(that.sdsRefreshDelay) :that.sdsRefreshDelay != null) return false;
            if (sdsUdsPath != null ? !sdsUdsPath.equals(that.sdsUdsPath) :that.sdsUdsPath != null) return false;
            return true;
    }


    public class ConnectTimeoutNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.ConnectTimeoutNested<N>> implements MeshConfigFluent.ConnectTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ConnectTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ConnectTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withConnectTimeout(builder.build());
    }
    public N endConnectTimeout(){
            return and();
    }

}
    public class DefaultConfigNestedImpl<N> extends ProxyConfigFluentImpl<MeshConfigFluent.DefaultConfigNested<N>> implements MeshConfigFluent.DefaultConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProxyConfigBuilder builder;
    
            DefaultConfigNestedImpl(ProxyConfig item){
                    this.builder = new ProxyConfigBuilder(this, item);
            }
            DefaultConfigNestedImpl(){
                    this.builder = new ProxyConfigBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withDefaultConfig(builder.build());
    }
    public N endDefaultConfig(){
            return and();
    }

}
    public class OutboundTrafficPolicyNestedImpl<N> extends OutboundTrafficPolicyFluentImpl<MeshConfigFluent.OutboundTrafficPolicyNested<N>> implements MeshConfigFluent.OutboundTrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OutboundTrafficPolicyBuilder builder;
    
            OutboundTrafficPolicyNestedImpl(OutboundTrafficPolicy item){
                    this.builder = new OutboundTrafficPolicyBuilder(this, item);
            }
            OutboundTrafficPolicyNestedImpl(){
                    this.builder = new OutboundTrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withOutboundTrafficPolicy(builder.build());
    }
    public N endOutboundTrafficPolicy(){
            return and();
    }

}
    public class RdsRefreshDelayNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.RdsRefreshDelayNested<N>> implements MeshConfigFluent.RdsRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            RdsRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            RdsRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withRdsRefreshDelay(builder.build());
    }
    public N endRdsRefreshDelay(){
            return and();
    }

}
    public class SdsRefreshDelayNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.SdsRefreshDelayNested<N>> implements MeshConfigFluent.SdsRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            SdsRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            SdsRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withSdsRefreshDelay(builder.build());
    }
    public N endSdsRefreshDelay(){
            return and();
    }

}


}
