package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Double;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CompressedAttributesFluent<A extends CompressedAttributesFluent<A>> extends Fluent<A>{


    public A addToBools(String key,Boolean value);
    public A addToBools(Map<String,Boolean> map);
    public A removeFromBools(String key);
    public A removeFromBools(Map<String,Boolean> map);
    public Map<String,Boolean> getBools();
    public A withBools(Map<String,Boolean> bools);
    public Boolean hasBools();
    public A addToBytes(String key,String value);
    public A addToBytes(Map<String,String> map);
    public A removeFromBytes(String key);
    public A removeFromBytes(Map<String,String> map);
    public Map<String,String> getBytes();
    public A withBytes(Map<String,String> bytes);
    public Boolean hasBytes();
    public A addToDoubles(String key,Double value);
    public A addToDoubles(Map<String,Double> map);
    public A removeFromDoubles(String key);
    public A removeFromDoubles(Map<String,Double> map);
    public Map<String,Double> getDoubles();
    public A withDoubles(Map<String,Double> doubles);
    public Boolean hasDoubles();
    public A addToDurations(String key,Long value);
    public A addToDurations(Map<String,Long> map);
    public A removeFromDurations(String key);
    public A removeFromDurations(Map<String,Long> map);
    public Map<String,Long> getDurations();
    public A withDurations(Map<String,Long> durations);
    public Boolean hasDurations();
    public A addToInt64s(String key,Long value);
    public A addToInt64s(Map<String,Long> map);
    public A removeFromInt64s(String key);
    public A removeFromInt64s(Map<String,Long> map);
    public Map<String,Long> getInt64s();
    public A withInt64s(Map<String,Long> int64s);
    public Boolean hasInt64s();
    public A addToStringMaps(String key,StringMap value);
    public A addToStringMaps(Map<String,StringMap> map);
    public A removeFromStringMaps(String key);
    public A removeFromStringMaps(Map<String,StringMap> map);
    public Map<String,StringMap> getStringMaps();
    public A withStringMaps(Map<String,StringMap> stringMaps);
    public Boolean hasStringMaps();
    public A addToStrings(String key,Integer value);
    public A addToStrings(Map<String,Integer> map);
    public A removeFromStrings(String key);
    public A removeFromStrings(Map<String,Integer> map);
    public Map<String,Integer> getStrings();
    public A withStrings(Map<String,Integer> strings);
    public Boolean hasStrings();
    public A addToTimestamps(String key,String value);
    public A addToTimestamps(Map<String,String> map);
    public A removeFromTimestamps(String key);
    public A removeFromTimestamps(Map<String,String> map);
    public Map<String,String> getTimestamps();
    public A withTimestamps(Map<String,String> timestamps);
    public Boolean hasTimestamps();
    public A addToWords(int index,String item);
    public A setToWords(int index,String item);
    public A addToWords(String... items);
    public A addAllToWords(Collection<String> items);
    public A removeFromWords(String... items);
    public A removeAllFromWords(Collection<String> items);
    public List<String> getWords();
    public String getWord(int index);
    public String getFirstWord();
    public String getLastWord();
    public String getMatchingWord(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withWords(List<String> words);
    public A withWords(String... words);
    public Boolean hasWords();



}
