package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ReferencedAttributesBuilder extends ReferencedAttributesFluentImpl<ReferencedAttributesBuilder> implements VisitableBuilder<ReferencedAttributes,ReferencedAttributesBuilder>{

    ReferencedAttributesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ReferencedAttributesBuilder(){
            this(true);
    }
    public ReferencedAttributesBuilder(Boolean validationEnabled){
            this(new ReferencedAttributes(), validationEnabled);
    }
    public ReferencedAttributesBuilder(ReferencedAttributesFluent<?> fluent){
            this(fluent, true);
    }
    public ReferencedAttributesBuilder(ReferencedAttributesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReferencedAttributes(), validationEnabled);
    }
    public ReferencedAttributesBuilder(ReferencedAttributesFluent<?> fluent,ReferencedAttributes instance){
            this(fluent, instance, true);
    }
    public ReferencedAttributesBuilder(ReferencedAttributesFluent<?> fluent,ReferencedAttributes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttributeMatches(instance.getAttributeMatches()); 
            fluent.withWords(instance.getWords()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReferencedAttributesBuilder(ReferencedAttributes instance){
            this(instance,true);
    }
    public ReferencedAttributesBuilder(ReferencedAttributes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttributeMatches(instance.getAttributeMatches()); 
            this.withWords(instance.getWords()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReferencedAttributesBuilder(Validator validator){
            this(new ReferencedAttributes(), true);
    }
    public ReferencedAttributesBuilder(ReferencedAttributesFluent<?> fluent,ReferencedAttributes instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAttributeMatches(instance.getAttributeMatches()); 
            fluent.withWords(instance.getWords()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ReferencedAttributesBuilder(ReferencedAttributes instance,Validator validator){
            this.fluent = this; 
            this.withAttributeMatches(instance.getAttributeMatches()); 
            this.withWords(instance.getWords()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ReferencedAttributes build(){
            ReferencedAttributes buildable = new ReferencedAttributes(fluent.getAttributeMatches(),fluent.getWords());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReferencedAttributesBuilder that = (ReferencedAttributesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
