
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributes",
    "defaultWords",
    "globalWordCount"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ReportRequest implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("attributes")
    @JsonPropertyDescription("")
    @Valid
    private List<CompressedAttributes> attributes = new ArrayList<CompressedAttributes>();
    /**
     * 
     * 
     */
    @JsonProperty("defaultWords")
    @JsonPropertyDescription("")
    @Valid
    private List<String> defaultWords = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("globalWordCount")
    @JsonPropertyDescription("")
    private Integer globalWordCount;
    private final static long serialVersionUID = -6132956526417411391L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ReportRequest() {
    }

    /**
     * 
     * @param globalWordCount
     * @param defaultWords
     * @param attributes
     */
    public ReportRequest(List<CompressedAttributes> attributes, List<String> defaultWords, Integer globalWordCount) {
        super();
        this.attributes = attributes;
        this.defaultWords = defaultWords;
        this.globalWordCount = globalWordCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributes")
    public List<CompressedAttributes> getAttributes() {
        return attributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributes")
    public void setAttributes(List<CompressedAttributes> attributes) {
        this.attributes = attributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultWords")
    public List<String> getDefaultWords() {
        return defaultWords;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultWords")
    public void setDefaultWords(List<String> defaultWords) {
        this.defaultWords = defaultWords;
    }

    /**
     * 
     * 
     */
    @JsonProperty("globalWordCount")
    public Integer getGlobalWordCount() {
        return globalWordCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("globalWordCount")
    public void setGlobalWordCount(Integer globalWordCount) {
        this.globalWordCount = globalWordCount;
    }

}
