package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ReportRequestFluentImpl<A extends ReportRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ReportRequestFluent<A>{

    private List<CompressedAttributesBuilder> attributes;
    private List<String> defaultWords;
    private Integer globalWordCount;

    public ReportRequestFluentImpl(){
    }
    public ReportRequestFluentImpl(ReportRequest instance){
            this.withAttributes(instance.getAttributes()); 
            this.withDefaultWords(instance.getDefaultWords()); 
            this.withGlobalWordCount(instance.getGlobalWordCount()); 
    }

    public A addToAttributes(int index,CompressedAttributes item){
            if (this.attributes == null) {this.attributes = new ArrayList<CompressedAttributesBuilder>();}
            CompressedAttributesBuilder builder = new CompressedAttributesBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.attributes.add(index >= 0 ? index : attributes.size(), builder); return (A)this;
    }

    public A setToAttributes(int index,CompressedAttributes item){
            if (this.attributes == null) {this.attributes = new ArrayList<CompressedAttributesBuilder>();}
            CompressedAttributesBuilder builder = new CompressedAttributesBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= attributes.size()) { attributes.add(builder); } else { attributes.set(index, builder);}
             return (A)this;
    }

    public A addToAttributes(CompressedAttributes... items){
            if (this.attributes == null) {this.attributes = new ArrayList<CompressedAttributesBuilder>();}
            for (CompressedAttributes item : items) {CompressedAttributesBuilder builder = new CompressedAttributesBuilder(item);_visitables.add(builder);this.attributes.add(builder);} return (A)this;
    }

    public A addAllToAttributes(Collection<CompressedAttributes> items){
            if (this.attributes == null) {this.attributes = new ArrayList<CompressedAttributesBuilder>();}
            for (CompressedAttributes item : items) {CompressedAttributesBuilder builder = new CompressedAttributesBuilder(item);_visitables.add(builder);this.attributes.add(builder);} return (A)this;
    }

    public A removeFromAttributes(CompressedAttributes... items){
            for (CompressedAttributes item : items) {CompressedAttributesBuilder builder = new CompressedAttributesBuilder(item);_visitables.remove(builder);if (this.attributes != null) {this.attributes.remove(builder);}} return (A)this;
    }

    public A removeAllFromAttributes(Collection<CompressedAttributes> items){
            for (CompressedAttributes item : items) {CompressedAttributesBuilder builder = new CompressedAttributesBuilder(item);_visitables.remove(builder);if (this.attributes != null) {this.attributes.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAttributes instead.
 * @return The buildable object.
 */
@Deprecated public List<CompressedAttributes> getAttributes(){
            return build(attributes);
    }

    public List<CompressedAttributes> buildAttributes(){
            return build(attributes);
    }

    public CompressedAttributes buildAttribute(int index){
            return this.attributes.get(index).build();
    }

    public CompressedAttributes buildFirstAttribute(){
            return this.attributes.get(0).build();
    }

    public CompressedAttributes buildLastAttribute(){
            return this.attributes.get(attributes.size() - 1).build();
    }

    public CompressedAttributes buildMatchingAttribute(io.fabric8.kubernetes.api.builder.Predicate<CompressedAttributesBuilder> predicate){
            for (CompressedAttributesBuilder item: attributes) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withAttributes(List<CompressedAttributes> attributes){
            if (this.attributes != null) { _visitables.removeAll(this.attributes);}
            if (attributes != null) {this.attributes = new ArrayList<CompressedAttributesBuilder>(); for (CompressedAttributes item : attributes){this.addToAttributes(item);}} else { this.attributes = null;} return (A) this;
    }

    public A withAttributes(CompressedAttributes... attributes){
            if (this.attributes != null) {this.attributes.clear();}
            if (attributes != null) {for (CompressedAttributes item :attributes){ this.addToAttributes(item);}} return (A) this;
    }

    public Boolean hasAttributes(){
            return attributes != null && !attributes.isEmpty();
    }

    public ReportRequestFluent.AttributesNested<A> addNewAttribute(){
            return new AttributesNestedImpl();
    }

    public ReportRequestFluent.AttributesNested<A> addNewAttributeLike(CompressedAttributes item){
            return new AttributesNestedImpl(-1, item);
    }

    public ReportRequestFluent.AttributesNested<A> setNewAttributeLike(int index,CompressedAttributes item){
            return new AttributesNestedImpl(index, item);
    }

    public ReportRequestFluent.AttributesNested<A> editAttribute(int index){
            if (attributes.size() <= index) throw new RuntimeException("Can't edit attributes. Index exceeds size.");
            return setNewAttributeLike(index, buildAttribute(index));
    }

    public ReportRequestFluent.AttributesNested<A> editFirstAttribute(){
            if (attributes.size() == 0) throw new RuntimeException("Can't edit first attributes. The list is empty.");
            return setNewAttributeLike(0, buildAttribute(0));
    }

    public ReportRequestFluent.AttributesNested<A> editLastAttribute(){
            int index = attributes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last attributes. The list is empty.");
            return setNewAttributeLike(index, buildAttribute(index));
    }

    public ReportRequestFluent.AttributesNested<A> editMatchingAttribute(io.fabric8.kubernetes.api.builder.Predicate<CompressedAttributesBuilder> predicate){
            int index = -1;
            for (int i=0;i<attributes.size();i++) { 
            if (predicate.apply(attributes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching attributes. No match found.");
            return setNewAttributeLike(index, buildAttribute(index));
    }

    public A addToDefaultWords(int index,String item){
            if (this.defaultWords == null) {this.defaultWords = new ArrayList<String>();}
            this.defaultWords.add(index, item);
            return (A)this;
    }

    public A setToDefaultWords(int index,String item){
            if (this.defaultWords == null) {this.defaultWords = new ArrayList<String>();}
            this.defaultWords.set(index, item); return (A)this;
    }

    public A addToDefaultWords(String... items){
            if (this.defaultWords == null) {this.defaultWords = new ArrayList<String>();}
            for (String item : items) {this.defaultWords.add(item);} return (A)this;
    }

    public A addAllToDefaultWords(Collection<String> items){
            if (this.defaultWords == null) {this.defaultWords = new ArrayList<String>();}
            for (String item : items) {this.defaultWords.add(item);} return (A)this;
    }

    public A removeFromDefaultWords(String... items){
            for (String item : items) {if (this.defaultWords!= null){ this.defaultWords.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultWords(Collection<String> items){
            for (String item : items) {if (this.defaultWords!= null){ this.defaultWords.remove(item);}} return (A)this;
    }

    public List<String> getDefaultWords(){
            return this.defaultWords;
    }

    public String getDefaultWord(int index){
            return this.defaultWords.get(index);
    }

    public String getFirstDefaultWord(){
            return this.defaultWords.get(0);
    }

    public String getLastDefaultWord(){
            return this.defaultWords.get(defaultWords.size() - 1);
    }

    public String getMatchingDefaultWord(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultWords) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withDefaultWords(List<String> defaultWords){
            if (this.defaultWords != null) { _visitables.removeAll(this.defaultWords);}
            if (defaultWords != null) {this.defaultWords = new ArrayList<String>(); for (String item : defaultWords){this.addToDefaultWords(item);}} else { this.defaultWords = null;} return (A) this;
    }

    public A withDefaultWords(String... defaultWords){
            if (this.defaultWords != null) {this.defaultWords.clear();}
            if (defaultWords != null) {for (String item :defaultWords){ this.addToDefaultWords(item);}} return (A) this;
    }

    public Boolean hasDefaultWords(){
            return defaultWords != null && !defaultWords.isEmpty();
    }

    public Integer getGlobalWordCount(){
            return this.globalWordCount;
    }

    public A withGlobalWordCount(Integer globalWordCount){
            this.globalWordCount=globalWordCount; return (A) this;
    }

    public Boolean hasGlobalWordCount(){
            return this.globalWordCount != null;
    }

    public A withNewGlobalWordCount(String arg1){
            return (A)withGlobalWordCount(new Integer(arg1));
    }

    public A withNewGlobalWordCount(int arg1){
            return (A)withGlobalWordCount(new Integer(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReportRequestFluentImpl that = (ReportRequestFluentImpl) o;
            if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
            if (defaultWords != null ? !defaultWords.equals(that.defaultWords) :that.defaultWords != null) return false;
            if (globalWordCount != null ? !globalWordCount.equals(that.globalWordCount) :that.globalWordCount != null) return false;
            return true;
    }


    public class AttributesNestedImpl<N> extends CompressedAttributesFluentImpl<ReportRequestFluent.AttributesNested<N>> implements ReportRequestFluent.AttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CompressedAttributesBuilder builder;
        private final int index;
    
            AttributesNestedImpl(int index,CompressedAttributes item){
                    this.index = index;
                    this.builder = new CompressedAttributesBuilder(this, item);
            }
            AttributesNestedImpl(){
                    this.index = -1;
                    this.builder = new CompressedAttributesBuilder(this);
            }
    
    public N and(){
            return (N) ReportRequestFluentImpl.this.setToAttributes(index, builder.build());
    }
    public N endAttribute(){
            return and();
    }

}


}
