package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface RouteDirectiveFluent<A extends RouteDirectiveFluent<A>> extends Fluent<A>{


    public String getDirectResponseBody();
    public A withDirectResponseBody(String directResponseBody);
    public Boolean hasDirectResponseBody();
    public Integer getDirectResponseCode();
    public A withDirectResponseCode(Integer directResponseCode);
    public Boolean hasDirectResponseCode();
    public A withNewDirectResponseCode(String arg1);
    public A withNewDirectResponseCode(int arg1);
    public A addToRequestHeaderOperations(int index,HeaderOperation item);
    public A setToRequestHeaderOperations(int index,HeaderOperation item);
    public A addToRequestHeaderOperations(HeaderOperation... items);
    public A addAllToRequestHeaderOperations(Collection<HeaderOperation> items);
    public A removeFromRequestHeaderOperations(HeaderOperation... items);
    public A removeAllFromRequestHeaderOperations(Collection<HeaderOperation> items);
    
/**
 * This method has been deprecated, please use method buildRequestHeaderOperations instead.
 * @return The buildable object.
 */
@Deprecated public List<HeaderOperation> getRequestHeaderOperations();
    public List<HeaderOperation> buildRequestHeaderOperations();
    public HeaderOperation buildRequestHeaderOperation(int index);
    public HeaderOperation buildFirstRequestHeaderOperation();
    public HeaderOperation buildLastRequestHeaderOperation();
    public HeaderOperation buildMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate);
    public A withRequestHeaderOperations(List<HeaderOperation> requestHeaderOperations);
    public A withRequestHeaderOperations(HeaderOperation... requestHeaderOperations);
    public Boolean hasRequestHeaderOperations();
    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> addNewRequestHeaderOperation();
    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> addNewRequestHeaderOperationLike(HeaderOperation item);
    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> setNewRequestHeaderOperationLike(int index,HeaderOperation item);
    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editRequestHeaderOperation(int index);
    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editFirstRequestHeaderOperation();
    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editLastRequestHeaderOperation();
    public RouteDirectiveFluent.RequestHeaderOperationsNested<A> editMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate);
    public A addToResponseHeaderOperations(int index,HeaderOperation item);
    public A setToResponseHeaderOperations(int index,HeaderOperation item);
    public A addToResponseHeaderOperations(HeaderOperation... items);
    public A addAllToResponseHeaderOperations(Collection<HeaderOperation> items);
    public A removeFromResponseHeaderOperations(HeaderOperation... items);
    public A removeAllFromResponseHeaderOperations(Collection<HeaderOperation> items);
    
/**
 * This method has been deprecated, please use method buildResponseHeaderOperations instead.
 * @return The buildable object.
 */
@Deprecated public List<HeaderOperation> getResponseHeaderOperations();
    public List<HeaderOperation> buildResponseHeaderOperations();
    public HeaderOperation buildResponseHeaderOperation(int index);
    public HeaderOperation buildFirstResponseHeaderOperation();
    public HeaderOperation buildLastResponseHeaderOperation();
    public HeaderOperation buildMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate);
    public A withResponseHeaderOperations(List<HeaderOperation> responseHeaderOperations);
    public A withResponseHeaderOperations(HeaderOperation... responseHeaderOperations);
    public Boolean hasResponseHeaderOperations();
    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> addNewResponseHeaderOperation();
    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> addNewResponseHeaderOperationLike(HeaderOperation item);
    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> setNewResponseHeaderOperationLike(int index,HeaderOperation item);
    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editResponseHeaderOperation(int index);
    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editFirstResponseHeaderOperation();
    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editLastResponseHeaderOperation();
    public RouteDirectiveFluent.ResponseHeaderOperationsNested<A> editMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationBuilder> predicate);

    public interface RequestHeaderOperationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HeaderOperationFluent<RouteDirectiveFluent.RequestHeaderOperationsNested<N>>{

        
    public N and();    public N endRequestHeaderOperation();
}
    public interface ResponseHeaderOperationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HeaderOperationFluent<RouteDirectiveFluent.ResponseHeaderOperationsNested<N>>{

        
    public N and();    public N endResponseHeaderOperation();
}


}
