
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "entries"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class StringMap implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("entries")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Integer> entries;
    private final static long serialVersionUID = 5851115271265484782L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StringMap() {
    }

    /**
     * 
     * @param entries
     */
    public StringMap(Map<String, Integer> entries) {
        super();
        this.entries = entries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("entries")
    public Map<String, Integer> getEntries() {
        return entries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("entries")
    public void setEntries(Map<String, Integer> entries) {
        this.entries = entries;
    }

}
