package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StringMapBuilder extends StringMapFluentImpl<StringMapBuilder> implements VisitableBuilder<StringMap,StringMapBuilder>{

    StringMapFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StringMapBuilder(){
            this(true);
    }
    public StringMapBuilder(Boolean validationEnabled){
            this(new StringMap(), validationEnabled);
    }
    public StringMapBuilder(StringMapFluent<?> fluent){
            this(fluent, true);
    }
    public StringMapBuilder(StringMapFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StringMap(), validationEnabled);
    }
    public StringMapBuilder(StringMapFluent<?> fluent,StringMap instance){
            this(fluent, instance, true);
    }
    public StringMapBuilder(StringMapFluent<?> fluent,StringMap instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEntries(instance.getEntries()); 
            this.validationEnabled = validationEnabled; 
    }
    public StringMapBuilder(StringMap instance){
            this(instance,true);
    }
    public StringMapBuilder(StringMap instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEntries(instance.getEntries()); 
            this.validationEnabled = validationEnabled; 
    }
    public StringMapBuilder(Validator validator){
            this(new StringMap(), true);
    }
    public StringMapBuilder(StringMapFluent<?> fluent,StringMap instance,Validator validator){
            this.fluent = fluent; 
            fluent.withEntries(instance.getEntries()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StringMapBuilder(StringMap instance,Validator validator){
            this.fluent = this; 
            this.withEntries(instance.getEntries()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public StringMap build(){
            StringMap buildable = new StringMap(fluent.getEntries());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StringMapBuilder that = (StringMapBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
