package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ConnectionPoolSettingsFluentImpl<A extends ConnectionPoolSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConnectionPoolSettingsFluent<A>{

    private HTTPSettingsBuilder http;
    private TCPSettingsBuilder tcp;

    public ConnectionPoolSettingsFluentImpl(){
    }
    public ConnectionPoolSettingsFluentImpl(ConnectionPoolSettings instance){
            this.withHttp(instance.getHttp()); 
            this.withTcp(instance.getTcp()); 
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public HTTPSettings getHttp(){
            return this.http!=null?this.http.build():null;
    }

    public HTTPSettings buildHttp(){
            return this.http!=null?this.http.build():null;
    }

    public A withHttp(HTTPSettings http){
            _visitables.remove(this.http);
            if (http!=null){ this.http= new HTTPSettingsBuilder(http); _visitables.add(this.http);} return (A) this;
    }

    public Boolean hasHttp(){
            return this.http != null;
    }

    public A withNewHttp(Integer http1MaxPendingRequests,Integer http2MaxRequests,Integer maxRequestsPerConnection,Integer maxRetries){
            return (A)withHttp(new HTTPSettings(http1MaxPendingRequests, http2MaxRequests, maxRequestsPerConnection, maxRetries));
    }

    public ConnectionPoolSettingsFluent.HttpNested<A> withNewHttp(){
            return new HttpNestedImpl();
    }

    public ConnectionPoolSettingsFluent.HttpNested<A> withNewHttpLike(HTTPSettings item){
            return new HttpNestedImpl(item);
    }

    public ConnectionPoolSettingsFluent.HttpNested<A> editHttp(){
            return withNewHttpLike(getHttp());
    }

    public ConnectionPoolSettingsFluent.HttpNested<A> editOrNewHttp(){
            return withNewHttpLike(getHttp() != null ? getHttp(): new HTTPSettingsBuilder().build());
    }

    public ConnectionPoolSettingsFluent.HttpNested<A> editOrNewHttpLike(HTTPSettings item){
            return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTcp instead.
 * @return The buildable object.
 */
@Deprecated public TCPSettings getTcp(){
            return this.tcp!=null?this.tcp.build():null;
    }

    public TCPSettings buildTcp(){
            return this.tcp!=null?this.tcp.build():null;
    }

    public A withTcp(TCPSettings tcp){
            _visitables.remove(this.tcp);
            if (tcp!=null){ this.tcp= new TCPSettingsBuilder(tcp); _visitables.add(this.tcp);} return (A) this;
    }

    public Boolean hasTcp(){
            return this.tcp != null;
    }

    public ConnectionPoolSettingsFluent.TcpNested<A> withNewTcp(){
            return new TcpNestedImpl();
    }

    public ConnectionPoolSettingsFluent.TcpNested<A> withNewTcpLike(TCPSettings item){
            return new TcpNestedImpl(item);
    }

    public ConnectionPoolSettingsFluent.TcpNested<A> editTcp(){
            return withNewTcpLike(getTcp());
    }

    public ConnectionPoolSettingsFluent.TcpNested<A> editOrNewTcp(){
            return withNewTcpLike(getTcp() != null ? getTcp(): new TCPSettingsBuilder().build());
    }

    public ConnectionPoolSettingsFluent.TcpNested<A> editOrNewTcpLike(TCPSettings item){
            return withNewTcpLike(getTcp() != null ? getTcp(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConnectionPoolSettingsFluentImpl that = (ConnectionPoolSettingsFluentImpl) o;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            if (tcp != null ? !tcp.equals(that.tcp) :that.tcp != null) return false;
            return true;
    }


    public class HttpNestedImpl<N> extends HTTPSettingsFluentImpl<ConnectionPoolSettingsFluent.HttpNested<N>> implements ConnectionPoolSettingsFluent.HttpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPSettingsBuilder builder;
    
            HttpNestedImpl(HTTPSettings item){
                    this.builder = new HTTPSettingsBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.builder = new HTTPSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ConnectionPoolSettingsFluentImpl.this.withHttp(builder.build());
    }
    public N endHttp(){
            return and();
    }

}
    public class TcpNestedImpl<N> extends TCPSettingsFluentImpl<ConnectionPoolSettingsFluent.TcpNested<N>> implements ConnectionPoolSettingsFluent.TcpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TCPSettingsBuilder builder;
    
            TcpNestedImpl(TCPSettings item){
                    this.builder = new TCPSettingsBuilder(this, item);
            }
            TcpNestedImpl(){
                    this.builder = new TCPSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ConnectionPoolSettingsFluentImpl.this.withTcp(builder.build());
    }
    public N endTcp(){
            return and();
    }

}


}
