package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DestinationFluentImpl<A extends DestinationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DestinationFluent<A>{

    private String host;
    private me.snowdrop.istio.api.networking.v1alpha3.PortSelectorBuilder port;
    private String subset;

    public DestinationFluentImpl(){
    }
    public DestinationFluentImpl(Destination instance){
            this.withHost(instance.getHost()); 
            this.withPort(instance.getPort()); 
            this.withSubset(instance.getSubset()); 
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1alpha3.PortSelector getPort(){
            return this.port!=null?this.port.build():null;
    }

    public me.snowdrop.istio.api.networking.v1alpha3.PortSelector buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(me.snowdrop.istio.api.networking.v1alpha3.PortSelector port){
            _visitables.remove(this.port);
            if (port!=null){ this.port= new me.snowdrop.istio.api.networking.v1alpha3.PortSelectorBuilder(port); _visitables.add(this.port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public DestinationFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public DestinationFluent.PortNested<A> withNewPortLike(me.snowdrop.istio.api.networking.v1alpha3.PortSelector item){
            return new PortNestedImpl(item);
    }

    public DestinationFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public DestinationFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new me.snowdrop.istio.api.networking.v1alpha3.PortSelectorBuilder().build());
    }

    public DestinationFluent.PortNested<A> editOrNewPortLike(me.snowdrop.istio.api.networking.v1alpha3.PortSelector item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public String getSubset(){
            return this.subset;
    }

    public A withSubset(String subset){
            this.subset=subset; return (A) this;
    }

    public Boolean hasSubset(){
            return this.subset != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationFluentImpl that = (DestinationFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (subset != null ? !subset.equals(that.subset) :that.subset != null) return false;
            return true;
    }


    public class PortNestedImpl<N> extends me.snowdrop.istio.api.networking.v1alpha3.PortSelectorFluentImpl<DestinationFluent.PortNested<N>> implements DestinationFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1alpha3.PortSelectorBuilder builder;
    
            PortNestedImpl(me.snowdrop.istio.api.networking.v1alpha3.PortSelector item){
                    this.builder = new me.snowdrop.istio.api.networking.v1alpha3.PortSelectorBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1alpha3.PortSelectorBuilder(this);
            }
    
    public N and(){
            return (N) DestinationFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
