package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class DestinationRuleListBuilder extends DestinationRuleListFluentImpl<DestinationRuleListBuilder> implements VisitableBuilder<DestinationRuleList,DestinationRuleListBuilder>{

    DestinationRuleListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DestinationRuleListBuilder(){
            this(true);
    }
    public DestinationRuleListBuilder(Boolean validationEnabled){
            this(new DestinationRuleList(), validationEnabled);
    }
    public DestinationRuleListBuilder(DestinationRuleListFluent<?> fluent){
            this(fluent, true);
    }
    public DestinationRuleListBuilder(DestinationRuleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DestinationRuleList(), validationEnabled);
    }
    public DestinationRuleListBuilder(DestinationRuleListFluent<?> fluent,DestinationRuleList instance){
            this(fluent, instance, true);
    }
    public DestinationRuleListBuilder(DestinationRuleListFluent<?> fluent,DestinationRuleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationRuleListBuilder(DestinationRuleList instance){
            this(instance,true);
    }
    public DestinationRuleListBuilder(DestinationRuleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationRuleListBuilder(Validator validator){
            this(new DestinationRuleList(), true);
    }
    public DestinationRuleListBuilder(DestinationRuleListFluent<?> fluent,DestinationRuleList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public DestinationRuleListBuilder(DestinationRuleList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public DestinationRuleList build(){
            DestinationRuleList buildable = new DestinationRuleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationRuleListBuilder that = (DestinationRuleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
