
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "host",
    "subsets",
    "trafficPolicy"
})
@IstioKind(name = "DestinationRule", plural = "destinationrules")
@IstioApiVersion("networking.istio.io/v1alpha3")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class DestinationRuleSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("host")
    @JsonPropertyDescription("")
    private String host;
    /**
     * 
     * 
     */
    @JsonProperty("subsets")
    @JsonPropertyDescription("")
    @Valid
    private List<Subset> subsets = new ArrayList<Subset>();
    /**
     * 
     * 
     */
    @JsonProperty("trafficPolicy")
    @JsonPropertyDescription("")
    @Valid
    private TrafficPolicy trafficPolicy;
    private final static long serialVersionUID = 5186386827982444370L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DestinationRuleSpec() {
    }

    /**
     * 
     * @param host
     * @param subsets
     * @param trafficPolicy
     */
    public DestinationRuleSpec(String host, List<Subset> subsets, TrafficPolicy trafficPolicy) {
        super();
        this.host = host;
        this.subsets = subsets;
        this.trafficPolicy = trafficPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("host")
    public String getHost() {
        return host;
    }

    /**
     * 
     * 
     */
    @JsonProperty("host")
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subsets")
    public List<Subset> getSubsets() {
        return subsets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subsets")
    public void setSubsets(List<Subset> subsets) {
        this.subsets = subsets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("trafficPolicy")
    public TrafficPolicy getTrafficPolicy() {
        return trafficPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("trafficPolicy")
    public void setTrafficPolicy(TrafficPolicy trafficPolicy) {
        this.trafficPolicy = trafficPolicy;
    }

}
