package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class DestinationRuleSpecFluentImpl<A extends DestinationRuleSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DestinationRuleSpecFluent<A>{

    private String host;
    private List<SubsetBuilder> subsets;
    private TrafficPolicyBuilder trafficPolicy;

    public DestinationRuleSpecFluentImpl(){
    }
    public DestinationRuleSpecFluentImpl(DestinationRuleSpec instance){
            this.withHost(instance.getHost()); 
            this.withSubsets(instance.getSubsets()); 
            this.withTrafficPolicy(instance.getTrafficPolicy()); 
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A addToSubsets(int index,Subset item){
            if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
            SubsetBuilder builder = new SubsetBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.subsets.add(index >= 0 ? index : subsets.size(), builder); return (A)this;
    }

    public A setToSubsets(int index,Subset item){
            if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
            SubsetBuilder builder = new SubsetBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= subsets.size()) { subsets.add(builder); } else { subsets.set(index, builder);}
             return (A)this;
    }

    public A addToSubsets(Subset... items){
            if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
            for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.add(builder);this.subsets.add(builder);} return (A)this;
    }

    public A addAllToSubsets(Collection<Subset> items){
            if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
            for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.add(builder);this.subsets.add(builder);} return (A)this;
    }

    public A removeFromSubsets(Subset... items){
            for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubsets(Collection<Subset> items){
            for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubsets instead.
 * @return The buildable object.
 */
@Deprecated public List<Subset> getSubsets(){
            return build(subsets);
    }

    public List<Subset> buildSubsets(){
            return build(subsets);
    }

    public Subset buildSubset(int index){
            return this.subsets.get(index).build();
    }

    public Subset buildFirstSubset(){
            return this.subsets.get(0).build();
    }

    public Subset buildLastSubset(){
            return this.subsets.get(subsets.size() - 1).build();
    }

    public Subset buildMatchingSubset(io.fabric8.kubernetes.api.builder.Predicate<SubsetBuilder> predicate){
            for (SubsetBuilder item: subsets) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withSubsets(List<Subset> subsets){
            if (this.subsets != null) { _visitables.removeAll(this.subsets);}
            if (subsets != null) {this.subsets = new ArrayList<SubsetBuilder>(); for (Subset item : subsets){this.addToSubsets(item);}} else { this.subsets = null;} return (A) this;
    }

    public A withSubsets(Subset... subsets){
            if (this.subsets != null) {this.subsets.clear();}
            if (subsets != null) {for (Subset item :subsets){ this.addToSubsets(item);}} return (A) this;
    }

    public Boolean hasSubsets(){
            return subsets != null && !subsets.isEmpty();
    }

    public DestinationRuleSpecFluent.SubsetsNested<A> addNewSubset(){
            return new SubsetsNestedImpl();
    }

    public DestinationRuleSpecFluent.SubsetsNested<A> addNewSubsetLike(Subset item){
            return new SubsetsNestedImpl(-1, item);
    }

    public DestinationRuleSpecFluent.SubsetsNested<A> setNewSubsetLike(int index,Subset item){
            return new SubsetsNestedImpl(index, item);
    }

    public DestinationRuleSpecFluent.SubsetsNested<A> editSubset(int index){
            if (subsets.size() <= index) throw new RuntimeException("Can't edit subsets. Index exceeds size.");
            return setNewSubsetLike(index, buildSubset(index));
    }

    public DestinationRuleSpecFluent.SubsetsNested<A> editFirstSubset(){
            if (subsets.size() == 0) throw new RuntimeException("Can't edit first subsets. The list is empty.");
            return setNewSubsetLike(0, buildSubset(0));
    }

    public DestinationRuleSpecFluent.SubsetsNested<A> editLastSubset(){
            int index = subsets.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subsets. The list is empty.");
            return setNewSubsetLike(index, buildSubset(index));
    }

    public DestinationRuleSpecFluent.SubsetsNested<A> editMatchingSubset(io.fabric8.kubernetes.api.builder.Predicate<SubsetBuilder> predicate){
            int index = -1;
            for (int i=0;i<subsets.size();i++) { 
            if (predicate.apply(subsets.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subsets. No match found.");
            return setNewSubsetLike(index, buildSubset(index));
    }

    
/**
 * This method has been deprecated, please use method buildTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public TrafficPolicy getTrafficPolicy(){
            return this.trafficPolicy!=null?this.trafficPolicy.build():null;
    }

    public TrafficPolicy buildTrafficPolicy(){
            return this.trafficPolicy!=null?this.trafficPolicy.build():null;
    }

    public A withTrafficPolicy(TrafficPolicy trafficPolicy){
            _visitables.remove(this.trafficPolicy);
            if (trafficPolicy!=null){ this.trafficPolicy= new TrafficPolicyBuilder(trafficPolicy); _visitables.add(this.trafficPolicy);} return (A) this;
    }

    public Boolean hasTrafficPolicy(){
            return this.trafficPolicy != null;
    }

    public DestinationRuleSpecFluent.TrafficPolicyNested<A> withNewTrafficPolicy(){
            return new TrafficPolicyNestedImpl();
    }

    public DestinationRuleSpecFluent.TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item){
            return new TrafficPolicyNestedImpl(item);
    }

    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editTrafficPolicy(){
            return withNewTrafficPolicyLike(getTrafficPolicy());
    }

    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editOrNewTrafficPolicy(){
            return withNewTrafficPolicyLike(getTrafficPolicy() != null ? getTrafficPolicy(): new TrafficPolicyBuilder().build());
    }

    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item){
            return withNewTrafficPolicyLike(getTrafficPolicy() != null ? getTrafficPolicy(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationRuleSpecFluentImpl that = (DestinationRuleSpecFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (subsets != null ? !subsets.equals(that.subsets) :that.subsets != null) return false;
            if (trafficPolicy != null ? !trafficPolicy.equals(that.trafficPolicy) :that.trafficPolicy != null) return false;
            return true;
    }


    public class SubsetsNestedImpl<N> extends SubsetFluentImpl<DestinationRuleSpecFluent.SubsetsNested<N>> implements DestinationRuleSpecFluent.SubsetsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubsetBuilder builder;
        private final int index;
    
            SubsetsNestedImpl(int index,Subset item){
                    this.index = index;
                    this.builder = new SubsetBuilder(this, item);
            }
            SubsetsNestedImpl(){
                    this.index = -1;
                    this.builder = new SubsetBuilder(this);
            }
    
    public N and(){
            return (N) DestinationRuleSpecFluentImpl.this.setToSubsets(index, builder.build());
    }
    public N endSubset(){
            return and();
    }

}
    public class TrafficPolicyNestedImpl<N> extends TrafficPolicyFluentImpl<DestinationRuleSpecFluent.TrafficPolicyNested<N>> implements DestinationRuleSpecFluent.TrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TrafficPolicyBuilder builder;
    
            TrafficPolicyNestedImpl(TrafficPolicy item){
                    this.builder = new TrafficPolicyBuilder(this, item);
            }
            TrafficPolicyNestedImpl(){
                    this.builder = new TrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) DestinationRuleSpecFluentImpl.this.withTrafficPolicy(builder.build());
    }
    public N endTrafficPolicy(){
            return and();
    }

}


}
