
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "labels",
    "ports"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Endpoint implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private java.lang.String address;
    /**
     * 
     * 
     */
    @JsonProperty("labels")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> labels;
    /**
     * 
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Integer> ports;
    private final static long serialVersionUID = 3411864117342857531L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Endpoint() {
    }

    /**
     * 
     * @param address
     * @param ports
     * @param labels
     */
    public Endpoint(java.lang.String address, Map<String, String> labels, Map<String, Integer> ports) {
        super();
        this.address = address;
        this.labels = labels;
        this.ports = ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labels")
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public Map<String, Integer> getPorts() {
        return ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public void setPorts(Map<String, Integer> ports) {
        this.ports = ports;
    }

}
