package me.snowdrop.istio.api.networking.v1alpha3;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface EndpointFluent<A extends EndpointFluent<A>> extends Fluent<A>{


    public String getAddress();
    public A withAddress(String address);
    public Boolean hasAddress();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public A addToPorts(String key,Integer value);
    public A addToPorts(Map<String,Integer> map);
    public A removeFromPorts(String key);
    public A removeFromPorts(Map<String,Integer> map);
    public Map<String,Integer> getPorts();
    public A withPorts(Map<String,Integer> ports);
    public Boolean hasPorts();



}
