package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface EnvoyFilterListFluent<A extends EnvoyFilterListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,EnvoyFilter item);
    public A setToItems(int index,EnvoyFilter item);
    public A addToItems(EnvoyFilter... items);
    public A addAllToItems(Collection<EnvoyFilter> items);
    public A removeFromItems(EnvoyFilter... items);
    public A removeAllFromItems(Collection<EnvoyFilter> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvoyFilter> getItems();
    public List<EnvoyFilter> buildItems();
    public EnvoyFilter buildItem(int index);
    public EnvoyFilter buildFirstItem();
    public EnvoyFilter buildLastItem();
    public EnvoyFilter buildMatchingItem(Predicate<EnvoyFilterBuilder> predicate);
    public A withItems(List<EnvoyFilter> items);
    public A withItems(EnvoyFilter... items);
    public Boolean hasItems();
    public EnvoyFilterListFluent.ItemsNested<A> addNewItem();
    public EnvoyFilterListFluent.ItemsNested<A> addNewItemLike(EnvoyFilter item);
    public EnvoyFilterListFluent.ItemsNested<A> setNewItemLike(int index,EnvoyFilter item);
    public EnvoyFilterListFluent.ItemsNested<A> editItem(int index);
    public EnvoyFilterListFluent.ItemsNested<A> editFirstItem();
    public EnvoyFilterListFluent.ItemsNested<A> editLastItem();
    public EnvoyFilterListFluent.ItemsNested<A> editMatchingItem(Predicate<EnvoyFilterBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,EnvoyFilterFluent<EnvoyFilterListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
