
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "filters",
    "workloadLabels"
})
@IstioKind(name = "EnvoyFilter", plural = "envoyfilters")
@IstioApiVersion("networking.istio.io/v1alpha3")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class EnvoyFilterSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("filters")
    @JsonPropertyDescription("")
    @Valid
    private List<Filter> filters = new ArrayList<Filter>();
    /**
     * 
     * 
     */
    @JsonProperty("workloadLabels")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> workloadLabels;
    private final static long serialVersionUID = -7257286341855957516L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EnvoyFilterSpec() {
    }

    /**
     * 
     * @param filters
     * @param workloadLabels
     */
    public EnvoyFilterSpec(List<Filter> filters, Map<String, String> workloadLabels) {
        super();
        this.filters = filters;
        this.workloadLabels = workloadLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filters")
    public List<Filter> getFilters() {
        return filters;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filters")
    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    /**
     * 
     * 
     */
    @JsonProperty("workloadLabels")
    public Map<String, String> getWorkloadLabels() {
        return workloadLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("workloadLabels")
    public void setWorkloadLabels(Map<String, String> workloadLabels) {
        this.workloadLabels = workloadLabels;
    }

}
