package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class EnvoyFilterSpecFluentImpl<A extends EnvoyFilterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EnvoyFilterSpecFluent<A>{

    private List<FilterBuilder> filters;
    private Map<String,String> workloadLabels;

    public EnvoyFilterSpecFluentImpl(){
    }
    public EnvoyFilterSpecFluentImpl(EnvoyFilterSpec instance){
            this.withFilters(instance.getFilters()); 
            this.withWorkloadLabels(instance.getWorkloadLabels()); 
    }

    public A addToFilters(int index,Filter item){
            if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
            FilterBuilder builder = new FilterBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.filters.add(index >= 0 ? index : filters.size(), builder); return (A)this;
    }

    public A setToFilters(int index,Filter item){
            if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
            FilterBuilder builder = new FilterBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= filters.size()) { filters.add(builder); } else { filters.set(index, builder);}
             return (A)this;
    }

    public A addToFilters(Filter... items){
            if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
            for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.add(builder);this.filters.add(builder);} return (A)this;
    }

    public A addAllToFilters(Collection<Filter> items){
            if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
            for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.add(builder);this.filters.add(builder);} return (A)this;
    }

    public A removeFromFilters(Filter... items){
            for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
    }

    public A removeAllFromFilters(Collection<Filter> items){
            for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildFilters instead.
 * @return The buildable object.
 */
@Deprecated public List<Filter> getFilters(){
            return build(filters);
    }

    public List<Filter> buildFilters(){
            return build(filters);
    }

    public Filter buildFilter(int index){
            return this.filters.get(index).build();
    }

    public Filter buildFirstFilter(){
            return this.filters.get(0).build();
    }

    public Filter buildLastFilter(){
            return this.filters.get(filters.size() - 1).build();
    }

    public Filter buildMatchingFilter(io.fabric8.kubernetes.api.builder.Predicate<FilterBuilder> predicate){
            for (FilterBuilder item: filters) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withFilters(List<Filter> filters){
            if (this.filters != null) { _visitables.removeAll(this.filters);}
            if (filters != null) {this.filters = new ArrayList<FilterBuilder>(); for (Filter item : filters){this.addToFilters(item);}} else { this.filters = null;} return (A) this;
    }

    public A withFilters(Filter... filters){
            if (this.filters != null) {this.filters.clear();}
            if (filters != null) {for (Filter item :filters){ this.addToFilters(item);}} return (A) this;
    }

    public Boolean hasFilters(){
            return filters != null && !filters.isEmpty();
    }

    public EnvoyFilterSpecFluent.FiltersNested<A> addNewFilter(){
            return new FiltersNestedImpl();
    }

    public EnvoyFilterSpecFluent.FiltersNested<A> addNewFilterLike(Filter item){
            return new FiltersNestedImpl(-1, item);
    }

    public EnvoyFilterSpecFluent.FiltersNested<A> setNewFilterLike(int index,Filter item){
            return new FiltersNestedImpl(index, item);
    }

    public EnvoyFilterSpecFluent.FiltersNested<A> editFilter(int index){
            if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
            return setNewFilterLike(index, buildFilter(index));
    }

    public EnvoyFilterSpecFluent.FiltersNested<A> editFirstFilter(){
            if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
            return setNewFilterLike(0, buildFilter(0));
    }

    public EnvoyFilterSpecFluent.FiltersNested<A> editLastFilter(){
            int index = filters.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
            return setNewFilterLike(index, buildFilter(index));
    }

    public EnvoyFilterSpecFluent.FiltersNested<A> editMatchingFilter(io.fabric8.kubernetes.api.builder.Predicate<FilterBuilder> predicate){
            int index = -1;
            for (int i=0;i<filters.size();i++) { 
            if (predicate.apply(filters.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
            return setNewFilterLike(index, buildFilter(index));
    }

    public A addToWorkloadLabels(String key,String value){
            if(this.workloadLabels == null && key != null && value != null) { this.workloadLabels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.workloadLabels.put(key, value);} return (A)this;
    }

    public A addToWorkloadLabels(Map<String,String> map){
            if(this.workloadLabels == null && map != null) { this.workloadLabels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.workloadLabels.putAll(map);} return (A)this;
    }

    public A removeFromWorkloadLabels(String key){
            if(this.workloadLabels == null) { return (A) this; }
            if(key != null && this.workloadLabels != null) {this.workloadLabels.remove(key);} return (A)this;
    }

    public A removeFromWorkloadLabels(Map<String,String> map){
            if(this.workloadLabels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.workloadLabels != null){this.workloadLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getWorkloadLabels(){
            return this.workloadLabels;
    }

    public A withWorkloadLabels(Map<String,String> workloadLabels){
            if (workloadLabels == null) { this.workloadLabels =  null;} else {this.workloadLabels = new LinkedHashMap<String,String>(workloadLabels);} return (A) this;
    }

    public Boolean hasWorkloadLabels(){
            return this.workloadLabels != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvoyFilterSpecFluentImpl that = (EnvoyFilterSpecFluentImpl) o;
            if (filters != null ? !filters.equals(that.filters) :that.filters != null) return false;
            if (workloadLabels != null ? !workloadLabels.equals(that.workloadLabels) :that.workloadLabels != null) return false;
            return true;
    }


    public class FiltersNestedImpl<N> extends FilterFluentImpl<EnvoyFilterSpecFluent.FiltersNested<N>> implements EnvoyFilterSpecFluent.FiltersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FilterBuilder builder;
        private final int index;
    
            FiltersNestedImpl(int index,Filter item){
                    this.index = index;
                    this.builder = new FilterBuilder(this, item);
            }
            FiltersNestedImpl(){
                    this.index = -1;
                    this.builder = new FilterBuilder(this);
            }
    
    public N and(){
            return (N) EnvoyFilterSpecFluentImpl.this.setToFilters(index, builder.build());
    }
    public N endFilter(){
            return and();
    }

}


}
