package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ExactMatchTypeBuilder extends ExactMatchTypeFluentImpl<ExactMatchTypeBuilder> implements VisitableBuilder<ExactMatchType,ExactMatchTypeBuilder>{

    ExactMatchTypeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ExactMatchTypeBuilder(){
            this(true);
    }
    public ExactMatchTypeBuilder(Boolean validationEnabled){
            this(new ExactMatchType(), validationEnabled);
    }
    public ExactMatchTypeBuilder(ExactMatchTypeFluent<?> fluent){
            this(fluent, true);
    }
    public ExactMatchTypeBuilder(ExactMatchTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExactMatchType(), validationEnabled);
    }
    public ExactMatchTypeBuilder(ExactMatchTypeFluent<?> fluent,ExactMatchType instance){
            this(fluent, instance, true);
    }
    public ExactMatchTypeBuilder(ExactMatchTypeFluent<?> fluent,ExactMatchType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExact(instance.getExact()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExactMatchTypeBuilder(ExactMatchType instance){
            this(instance,true);
    }
    public ExactMatchTypeBuilder(ExactMatchType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExact(instance.getExact()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExactMatchTypeBuilder(Validator validator){
            this(new ExactMatchType(), true);
    }
    public ExactMatchTypeBuilder(ExactMatchTypeFluent<?> fluent,ExactMatchType instance,Validator validator){
            this.fluent = fluent; 
            fluent.withExact(instance.getExact()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ExactMatchTypeBuilder(ExactMatchType instance,Validator validator){
            this.fluent = this; 
            this.withExact(instance.getExact()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ExactMatchType build(){
            ExactMatchType buildable = new ExactMatchType(fluent.getExact());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExactMatchTypeBuilder that = (ExactMatchTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
