package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ExponentialDelayHttpDelayTypeBuilder extends ExponentialDelayHttpDelayTypeFluentImpl<ExponentialDelayHttpDelayTypeBuilder> implements VisitableBuilder<ExponentialDelayHttpDelayType,ExponentialDelayHttpDelayTypeBuilder>{

    ExponentialDelayHttpDelayTypeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ExponentialDelayHttpDelayTypeBuilder(){
            this(true);
    }
    public ExponentialDelayHttpDelayTypeBuilder(Boolean validationEnabled){
            this(new ExponentialDelayHttpDelayType(), validationEnabled);
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayTypeFluent<?> fluent){
            this(fluent, true);
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExponentialDelayHttpDelayType(), validationEnabled);
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayTypeFluent<?> fluent,ExponentialDelayHttpDelayType instance){
            this(fluent, instance, true);
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayTypeFluent<?> fluent,ExponentialDelayHttpDelayType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExponentialDelay(instance.getExponentialDelay()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayType instance){
            this(instance,true);
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExponentialDelay(instance.getExponentialDelay()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExponentialDelayHttpDelayTypeBuilder(Validator validator){
            this(new ExponentialDelayHttpDelayType(), true);
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayTypeFluent<?> fluent,ExponentialDelayHttpDelayType instance,Validator validator){
            this.fluent = fluent; 
            fluent.withExponentialDelay(instance.getExponentialDelay()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ExponentialDelayHttpDelayTypeBuilder(ExponentialDelayHttpDelayType instance,Validator validator){
            this.fluent = this; 
            this.withExponentialDelay(instance.getExponentialDelay()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ExponentialDelayHttpDelayType build(){
            ExponentialDelayHttpDelayType buildable = new ExponentialDelayHttpDelayType(fluent.getExponentialDelay());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExponentialDelayHttpDelayTypeBuilder that = (ExponentialDelayHttpDelayTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
