package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HTTPRewriteBuilder extends HTTPRewriteFluentImpl<HTTPRewriteBuilder> implements VisitableBuilder<HTTPRewrite,HTTPRewriteBuilder>{

    HTTPRewriteFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPRewriteBuilder(){
            this(true);
    }
    public HTTPRewriteBuilder(Boolean validationEnabled){
            this(new HTTPRewrite(), validationEnabled);
    }
    public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPRewrite(), validationEnabled);
    }
    public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent,HTTPRewrite instance){
            this(fluent, instance, true);
    }
    public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent,HTTPRewrite instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthority(instance.getAuthority()); 
            fluent.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRewriteBuilder(HTTPRewrite instance){
            this(instance,true);
    }
    public HTTPRewriteBuilder(HTTPRewrite instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthority(instance.getAuthority()); 
            this.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRewriteBuilder(Validator validator){
            this(new HTTPRewrite(), true);
    }
    public HTTPRewriteBuilder(HTTPRewriteFluent<?> fluent,HTTPRewrite instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAuthority(instance.getAuthority()); 
            fluent.withUri(instance.getUri()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HTTPRewriteBuilder(HTTPRewrite instance,Validator validator){
            this.fluent = this; 
            this.withAuthority(instance.getAuthority()); 
            this.withUri(instance.getUri()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HTTPRewrite build(){
            HTTPRewrite buildable = new HTTPRewrite(fluent.getAuthority(),fluent.getUri());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPRewriteBuilder that = (HTTPRewriteBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
