
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "appendHeaders",
    "corsPolicy",
    "fault",
    "match",
    "mirror",
    "redirect",
    "removeResponseHeaders",
    "retries",
    "rewrite",
    "route",
    "timeout",
    "websocketUpgrade"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRoute implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("appendHeaders")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> appendHeaders;
    /**
     * 
     * 
     */
    @JsonProperty("corsPolicy")
    @JsonPropertyDescription("")
    @Valid
    private CorsPolicy corsPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("fault")
    @JsonPropertyDescription("")
    @Valid
    private HTTPFaultInjection fault;
    /**
     * 
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    @Valid
    private List<HTTPMatchRequest> match = new ArrayList<HTTPMatchRequest>();
    /**
     * 
     * 
     */
    @JsonProperty("mirror")
    @JsonPropertyDescription("")
    @Valid
    private Destination mirror;
    /**
     * 
     * 
     */
    @JsonProperty("redirect")
    @JsonPropertyDescription("")
    @Valid
    private HTTPRedirect redirect;
    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    @JsonPropertyDescription("")
    @Valid
    private List<java.lang.String> removeResponseHeaders = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("retries")
    @JsonPropertyDescription("")
    @Valid
    private HTTPRetry retries;
    /**
     * 
     * 
     */
    @JsonProperty("rewrite")
    @JsonPropertyDescription("")
    @Valid
    private HTTPRewrite rewrite;
    /**
     * 
     * 
     */
    @JsonProperty("route")
    @JsonPropertyDescription("")
    @Valid
    private List<DestinationWeight> route = new ArrayList<DestinationWeight>();
    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    @JsonPropertyDescription("")
    @Valid
    private Duration timeout;
    /**
     * 
     * 
     */
    @JsonProperty("websocketUpgrade")
    @JsonPropertyDescription("")
    private Boolean websocketUpgrade;
    private final static long serialVersionUID = 2171493943463362680L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRoute() {
    }

    /**
     * 
     * @param redirect
     * @param websocketUpgrade
     * @param retries
     * @param mirror
     * @param route
     * @param removeResponseHeaders
     * @param corsPolicy
     * @param match
     * @param fault
     * @param appendHeaders
     * @param rewrite
     * @param timeout
     */
    public HTTPRoute(Map<String, String> appendHeaders, CorsPolicy corsPolicy, HTTPFaultInjection fault, List<HTTPMatchRequest> match, Destination mirror, HTTPRedirect redirect, List<java.lang.String> removeResponseHeaders, HTTPRetry retries, HTTPRewrite rewrite, List<DestinationWeight> route, Duration timeout, Boolean websocketUpgrade) {
        super();
        this.appendHeaders = appendHeaders;
        this.corsPolicy = corsPolicy;
        this.fault = fault;
        this.match = match;
        this.mirror = mirror;
        this.redirect = redirect;
        this.removeResponseHeaders = removeResponseHeaders;
        this.retries = retries;
        this.rewrite = rewrite;
        this.route = route;
        this.timeout = timeout;
        this.websocketUpgrade = websocketUpgrade;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendHeaders")
    public Map<String, String> getAppendHeaders() {
        return appendHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendHeaders")
    public void setAppendHeaders(Map<String, String> appendHeaders) {
        this.appendHeaders = appendHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("corsPolicy")
    public CorsPolicy getCorsPolicy() {
        return corsPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("corsPolicy")
    public void setCorsPolicy(CorsPolicy corsPolicy) {
        this.corsPolicy = corsPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fault")
    public HTTPFaultInjection getFault() {
        return fault;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fault")
    public void setFault(HTTPFaultInjection fault) {
        this.fault = fault;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public List<HTTPMatchRequest> getMatch() {
        return match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public void setMatch(List<HTTPMatchRequest> match) {
        this.match = match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mirror")
    public Destination getMirror() {
        return mirror;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mirror")
    public void setMirror(Destination mirror) {
        this.mirror = mirror;
    }

    /**
     * 
     * 
     */
    @JsonProperty("redirect")
    public HTTPRedirect getRedirect() {
        return redirect;
    }

    /**
     * 
     * 
     */
    @JsonProperty("redirect")
    public void setRedirect(HTTPRedirect redirect) {
        this.redirect = redirect;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    public List<java.lang.String> getRemoveResponseHeaders() {
        return removeResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    public void setRemoveResponseHeaders(List<java.lang.String> removeResponseHeaders) {
        this.removeResponseHeaders = removeResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("retries")
    public HTTPRetry getRetries() {
        return retries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("retries")
    public void setRetries(HTTPRetry retries) {
        this.retries = retries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewrite")
    public HTTPRewrite getRewrite() {
        return rewrite;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewrite")
    public void setRewrite(HTTPRewrite rewrite) {
        this.rewrite = rewrite;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public List<DestinationWeight> getRoute() {
        return route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public void setRoute(List<DestinationWeight> route) {
        this.route = route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    public Duration getTimeout() {
        return timeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("websocketUpgrade")
    public Boolean getWebsocketUpgrade() {
        return websocketUpgrade;
    }

    /**
     * 
     * 
     */
    @JsonProperty("websocketUpgrade")
    public void setWebsocketUpgrade(Boolean websocketUpgrade) {
        this.websocketUpgrade = websocketUpgrade;
    }

}
