package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class Http2ErrorErrorTypeBuilder extends Http2ErrorErrorTypeFluentImpl<Http2ErrorErrorTypeBuilder> implements VisitableBuilder<Http2ErrorErrorType,Http2ErrorErrorTypeBuilder>{

    Http2ErrorErrorTypeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public Http2ErrorErrorTypeBuilder(){
            this(true);
    }
    public Http2ErrorErrorTypeBuilder(Boolean validationEnabled){
            this(new Http2ErrorErrorType(), validationEnabled);
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorTypeFluent<?> fluent){
            this(fluent, true);
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Http2ErrorErrorType(), validationEnabled);
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorTypeFluent<?> fluent,Http2ErrorErrorType instance){
            this(fluent, instance, true);
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorTypeFluent<?> fluent,Http2ErrorErrorType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttp2Error(instance.getHttp2Error()); 
            this.validationEnabled = validationEnabled; 
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorType instance){
            this(instance,true);
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttp2Error(instance.getHttp2Error()); 
            this.validationEnabled = validationEnabled; 
    }
    public Http2ErrorErrorTypeBuilder(Validator validator){
            this(new Http2ErrorErrorType(), true);
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorTypeFluent<?> fluent,Http2ErrorErrorType instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHttp2Error(instance.getHttp2Error()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public Http2ErrorErrorTypeBuilder(Http2ErrorErrorType instance,Validator validator){
            this.fluent = this; 
            this.withHttp2Error(instance.getHttp2Error()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Http2ErrorErrorType build(){
            Http2ErrorErrorType buildable = new Http2ErrorErrorType(fluent.getHttp2Error());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            Http2ErrorErrorTypeBuilder that = (Http2ErrorErrorTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
