
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.ConsistentHashLB.HashKey;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "httpCookie"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HttpCookieHashKey implements Serializable, HashKey
{

    /**
     * 
     * 
     */
    @JsonProperty("httpCookie")
    @JsonPropertyDescription("")
    @Valid
    private HTTPCookie httpCookie;
    private final static long serialVersionUID = -8854695040022738680L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HttpCookieHashKey() {
    }

    /**
     * 
     * @param httpCookie
     */
    public HttpCookieHashKey(HTTPCookie httpCookie) {
        super();
        this.httpCookie = httpCookie;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpCookie")
    public HTTPCookie getHttpCookie() {
        return httpCookie;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpCookie")
    public void setHttpCookie(HTTPCookie httpCookie) {
        this.httpCookie = httpCookie;
    }

}
