package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HttpStatusErrorTypeBuilder extends HttpStatusErrorTypeFluentImpl<HttpStatusErrorTypeBuilder> implements VisitableBuilder<HttpStatusErrorType,HttpStatusErrorTypeBuilder>{

    HttpStatusErrorTypeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HttpStatusErrorTypeBuilder(){
            this(true);
    }
    public HttpStatusErrorTypeBuilder(Boolean validationEnabled){
            this(new HttpStatusErrorType(), validationEnabled);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent){
            this(fluent, true);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HttpStatusErrorType(), validationEnabled);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent,HttpStatusErrorType instance){
            this(fluent, instance, true);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent,HttpStatusErrorType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttpStatus(instance.getHttpStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorType instance){
            this(instance,true);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttpStatus(instance.getHttpStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public HttpStatusErrorTypeBuilder(Validator validator){
            this(new HttpStatusErrorType(), true);
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorTypeFluent<?> fluent,HttpStatusErrorType instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHttpStatus(instance.getHttpStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HttpStatusErrorTypeBuilder(HttpStatusErrorType instance,Validator validator){
            this.fluent = this; 
            this.withHttpStatus(instance.getHttpStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HttpStatusErrorType build(){
            HttpStatusErrorType buildable = new HttpStatusErrorType(fluent.getHttpStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HttpStatusErrorTypeBuilder that = (HttpStatusErrorTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
