
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "index",
    "relativeTo"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class InsertPosition implements Serializable
{

    @JsonProperty("index")
    private Index index;
    /**
     * 
     * 
     */
    @JsonProperty("relativeTo")
    @JsonPropertyDescription("")
    private String relativeTo;
    private final static long serialVersionUID = -7879028935701247636L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public InsertPosition() {
    }

    /**
     * 
     * @param relativeTo
     * @param index
     */
    public InsertPosition(Index index, String relativeTo) {
        super();
        this.index = index;
        this.relativeTo = relativeTo;
    }

    @JsonProperty("index")
    public Index getIndex() {
        return index;
    }

    @JsonProperty("index")
    public void setIndex(Index index) {
        this.index = index;
    }

    /**
     * 
     * 
     */
    @JsonProperty("relativeTo")
    public String getRelativeTo() {
        return relativeTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("relativeTo")
    public void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

}
